/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result.chunk;

import com.alibaba.polardbx.common.exception.NotSupportException;
import com.alibaba.polardbx.rpc.result.chunk.BlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.Decimal;
import com.alibaba.polardbx.rpc.result.chunk.Slice;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.util.List;

public abstract class AbstractBlockDecoder
implements BlockDecoder {
    protected final PolarxResultset.Chunk chunk;
    protected final int columnIndex;
    protected final CodedInputStream stream;
    protected final ByteString null_bitmap;
    protected final PolarxResultset.ColumnMetaData meta;
    protected int rowIndex;
    protected boolean currentNull;

    public AbstractBlockDecoder(PolarxResultset.Chunk chunk, int columnIndex, PolarxResultset.ColumnMetaData meta) {
        this.chunk = chunk;
        this.columnIndex = columnIndex;
        PolarxResultset.Column column = chunk.getColumns(columnIndex);
        this.stream = column.hasFixedSizeColumn() ? column.getFixedSizeColumn().getValue().newCodedInput() : column.getVariableSizeColumn().getValue().newCodedInput();
        this.null_bitmap = chunk.getColumns(columnIndex).hasNullBitmap() ? chunk.getColumns(columnIndex).getNullBitmap() : null;
        this.meta = meta;
        this.rowIndex = -1;
        this.currentNull = true;
    }

    @Override
    public int rowCount() {
        return this.chunk.getRowCount();
    }

    @Override
    public int restCount() {
        if (this.rowIndex < 0) {
            return this.rowCount();
        }
        if (this.rowIndex >= this.rowCount() - 1) {
            return 0;
        }
        return this.rowCount() - this.rowIndex - 1;
    }

    private boolean internalIsNull() {
        if (null == this.null_bitmap) {
            return false;
        }
        int offset = this.rowIndex / 8;
        int bit_offset = this.rowIndex % 8;
        return (this.null_bitmap.byteAt(offset) & 1 << 7 - bit_offset) != 0;
    }

    @Override
    public boolean next() throws Exception {
        if (this.rowIndex < this.rowCount() - 1) {
            ++this.rowIndex;
            this.currentNull = this.internalIsNull();
            return true;
        }
        return false;
    }

    @Override
    public boolean isNull() throws Exception {
        return this.currentNull;
    }

    @Override
    public long getLong() throws Exception {
        throw new NotSupportException(new String[]{"XChunkDecoder getLong from " + this.getClass().getSimpleName()});
    }

    @Override
    public float getFloat() throws Exception {
        throw new NotSupportException(new String[]{"XChunkDecoder getFloat from " + this.getClass().getSimpleName()});
    }

    @Override
    public double getDouble() throws Exception {
        throw new NotSupportException(new String[]{"XChunkDecoder getDouble from " + this.getClass().getSimpleName()});
    }

    @Override
    public long getDate() throws Exception {
        throw new NotSupportException(new String[]{"XChunkDecoder getDate from " + this.getClass().getSimpleName()});
    }

    @Override
    public long getBit() throws Exception {
        throw new NotSupportException(new String[]{"XChunkDecoder getBit from " + this.getClass().getSimpleName()});
    }

    @Override
    public long getTime() throws Exception {
        throw new NotSupportException(new String[]{"XChunkDecoder getTime from " + this.getClass().getSimpleName()});
    }

    @Override
    public long getDatetime() throws Exception {
        throw new NotSupportException(new String[]{"XChunkDecoder getDatetime from " + this.getClass().getSimpleName()});
    }

    @Override
    public Decimal getDecimal() throws Exception {
        throw new NotSupportException(new String[]{"XChunkDecoder getDecimal from " + this.getClass().getSimpleName()});
    }

    @Override
    public List<Slice> getSet() throws Exception {
        throw new NotSupportException(new String[]{"XChunkDecoder getSet from " + this.getClass().getSimpleName()});
    }

    @Override
    public Slice getString() throws Exception {
        throw new NotSupportException(new String[]{"XChunkDecoder getString from " + this.getClass().getSimpleName()});
    }
}

