/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result.chunk.block;

import com.alibaba.polardbx.rpc.result.chunk.Decimal;
import com.alibaba.polardbx.rpc.result.chunk.Slice;
import com.alibaba.polardbx.rpc.result.chunk.block.LongBlockDecoder;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.sql.Date;

public class DateBlockDecoder
extends LongBlockDecoder {
    public DateBlockDecoder(PolarxResultset.Chunk chunk, int columnIndex, PolarxResultset.ColumnMetaData meta) {
        super(chunk, columnIndex, meta);
    }

    @Override
    public Object getObject() throws Exception {
        return this.currentNull ? null : DateBlockDecoder.longToDate(this.getDate());
    }

    @Override
    public long getDate() throws Exception {
        assert (!this.currentNull);
        return super.getLong();
    }

    @Override
    public long getLong() throws Exception {
        assert (!this.currentNull);
        long raw = super.getLong();
        boolean negative = raw < 0L;
        if (negative) {
            raw = -raw;
        }
        long ymdhms = raw >> 24;
        long ymd = ymdhms >> 17;
        long ym = ymd >> 5;
        long day = ymd % 32L;
        long month = ym % 13L;
        long year = ym / 13L;
        return (long)(negative ? -1 : 1) * (year * 10000L + month * 100L + day);
    }

    @Override
    public float getFloat() throws Exception {
        assert (!this.currentNull);
        return this.getLong();
    }

    @Override
    public double getDouble() throws Exception {
        assert (!this.currentNull);
        return this.getLong();
    }

    @Override
    public long getTime() throws Exception {
        assert (!this.currentNull);
        return super.getLong();
    }

    @Override
    public long getDatetime() throws Exception {
        assert (!this.currentNull);
        return super.getLong();
    }

    @Override
    public Decimal getDecimal() throws Exception {
        if (this.currentNull) {
            return null;
        }
        return new Decimal(this.getLong(), 0);
    }

    @Override
    public Slice getString() throws Exception {
        if (this.currentNull) {
            return null;
        }
        String str = DateBlockDecoder.longToString(this.getDate());
        byte[] bytes = str.getBytes();
        return new Slice(bytes, 0, bytes.length);
    }

    public static String longToString(long date) {
        boolean negative = date < 0L;
        if (negative) {
            date = -date;
        }
        long ymdhms = date >> 24;
        long ymd = ymdhms >> 17;
        long ym = ymd >> 5;
        long day = ymd % 32L;
        long month = ym % 13L;
        long year = ym / 13L;
        return String.format("%s%04d-%02d-%02d", negative ? "-" : "", year, month, day);
    }

    public static Date longToDate(long date) {
        boolean negative = date < 0L;
        if (negative) {
            date = -date;
        }
        long ymdhms = date >> 24;
        long ymd = ymdhms >> 17;
        long ym = ymd >> 5;
        long day = ymd % 32L;
        long month = ym % 13L;
        long year = ym / 13L;
        return new Date((int)((negative ? -year : year) - 1900L), (int)(month - 1L), (int)day);
    }
}

