/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result.chunk.block;

import com.alibaba.polardbx.rpc.result.chunk.Decimal;
import com.alibaba.polardbx.rpc.result.chunk.Slice;
import com.alibaba.polardbx.rpc.result.chunk.block.LongBlockDecoder;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.sql.Timestamp;

public class DatetimeBlockDecoder
extends LongBlockDecoder {
    public DatetimeBlockDecoder(PolarxResultset.Chunk chunk, int columnIndex, PolarxResultset.ColumnMetaData meta) {
        super(chunk, columnIndex, meta);
    }

    @Override
    public Object getObject() throws Exception {
        return this.currentNull ? null : DatetimeBlockDecoder.longToTimestamp(this.getDatetime());
    }

    @Override
    public long getDatetime() throws Exception {
        assert (!this.currentNull);
        return super.getLong();
    }

    @Override
    public long getLong() throws Exception {
        assert (!this.currentNull);
        return DatetimeBlockDecoder.longToTimestamp(this.getDatetime()).getTime();
    }

    @Override
    public float getFloat() throws Exception {
        assert (!this.currentNull);
        return this.getLong();
    }

    @Override
    public double getDouble() throws Exception {
        assert (!this.currentNull);
        return this.getLong();
    }

    @Override
    public long getDate() throws Exception {
        assert (!this.currentNull);
        return super.getLong();
    }

    @Override
    public long getTime() throws Exception {
        assert (!this.currentNull);
        return super.getLong();
    }

    @Override
    public Decimal getDecimal() throws Exception {
        if (this.currentNull) {
            return null;
        }
        return new Decimal(this.getLong(), 0);
    }

    @Override
    public Slice getString() throws Exception {
        if (this.currentNull) {
            return null;
        }
        String str = DatetimeBlockDecoder.longToString(this.getDate());
        byte[] bytes = str.getBytes();
        return new Slice(bytes, 0, bytes.length);
    }

    public static String longToString(long datetime) {
        boolean negative = datetime < 0L;
        if (negative) {
            datetime = -datetime;
        }
        long micros = datetime % 0x1000000L;
        long ymdhms = datetime >> 24;
        long ymd = ymdhms >> 17;
        long ym = ymd >> 5;
        long hms = ymdhms % 131072L;
        long day = ymd % 32L;
        long month = ym % 13L;
        long year = ym / 13L;
        long second = hms % 64L;
        long minute = (hms >> 6) % 64L;
        long hour = hms >> 12;
        return String.format("%s%04d-%02d-%02d %02d:%02d:%02d.%06d", negative ? "-" : "", year, month, day, hour, minute, second, micros);
    }

    public static Timestamp longToTimestamp(long datetime) {
        boolean negative = datetime < 0L;
        if (negative) {
            datetime = -datetime;
        }
        long micros = datetime % 0x1000000L;
        long ymdhms = datetime >> 24;
        long ymd = ymdhms >> 17;
        long ym = ymd >> 5;
        long hms = ymdhms % 131072L;
        long day = ymd % 32L;
        long month = ym % 13L;
        long year = ym / 13L;
        long second = hms % 64L;
        long minute = (hms >> 6) % 64L;
        long hour = hms >> 12;
        return new Timestamp((int)((negative ? -year : year) - 1900L), (int)(month - 1L), (int)day, (int)hour, (int)minute, (int)second, (int)(micros * 1000L));
    }
}

