/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result.chunk.block;

import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.rpc.result.chunk.AbstractBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.Decimal;
import com.alibaba.polardbx.rpc.result.chunk.Slice;
import com.google.protobuf.CodedInputStream;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;

public class DecimalBlockDecoder
extends AbstractBlockDecoder {
    private static long LONG_OVERFLOW_M10D10 = 0xCCCCCCCCCCCCCCBL;
    private Decimal currentValue = null;

    public DecimalBlockDecoder(PolarxResultset.Chunk chunk, int columnIndex, PolarxResultset.ColumnMetaData meta) {
        super(chunk, columnIndex, meta);
    }

    public static Decimal decode(CodedInputStream stream, int length) throws Exception {
        int idx;
        byte scale = stream.readRawByte();
        byte[] buf = stream.readRawBytes(length - 1);
        long unscaled = 0L;
        boolean overflow = false;
        int sign = 0;
        for (idx = 0; idx < buf.length; ++idx) {
            int b = 0xFF & buf[idx];
            if (b >> 4 > 9) {
                sign = (byte)(b >> 4);
                break;
            }
            if (unscaled >= LONG_OVERFLOW_M10D10) {
                overflow = true;
                break;
            }
            unscaled = 10L * unscaled + (long)(b >> 4);
            if ((b & 0xF) > 9) {
                sign = (byte)(b & 0xF);
                break;
            }
            if (unscaled >= LONG_OVERFLOW_M10D10) {
                overflow = true;
                break;
            }
            unscaled = 10L * unscaled + (long)(b & 0xF);
        }
        if (!overflow) {
            if (idx != buf.length) {
                throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Did not read all bytes while decoding decimal. Bytes left: " + (buf.length - idx)});
            }
            switch (sign) {
                case 11: 
                case 13: {
                    unscaled = -unscaled;
                }
            }
            return new Decimal(unscaled, (int)scale);
        }
        CharBuffer unscaledString = CharBuffer.allocate(2 * buf.length);
        unscaledString.position(1);
        sign = 0;
        for (idx = 0; idx < buf.length; ++idx) {
            int b = 0xFF & buf[idx];
            if (b >> 4 > 9) {
                sign = (byte)(b >> 4);
                break;
            }
            unscaledString.append((char)((b >> 4) + 48));
            if ((b & 0xF) > 9) {
                sign = (byte)(b & 0xF);
                break;
            }
            unscaledString.append((char)((b & 0xF) + 48));
        }
        if (idx != buf.length) {
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Did not read all bytes while decoding decimal. Bytes left: " + (buf.length - idx)});
        }
        switch (sign) {
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                unscaledString.put(0, '+');
                break;
            }
            case 11: 
            case 13: {
                unscaledString.put(0, '-');
            }
        }
        int characters = unscaledString.position();
        unscaledString.clear();
        BigInteger bigUnscaled = new BigInteger(unscaledString.subSequence(0, characters).toString());
        return new Decimal(bigUnscaled, (int)scale);
    }

    @Override
    public boolean next() throws Exception {
        boolean hasNext = super.next();
        if (hasNext) {
            if (this.currentNull) {
                this.currentValue = null;
            } else {
                int rowLen = this.stream.readInt32();
                assert (rowLen > 1);
                this.currentValue = DecimalBlockDecoder.decode(this.stream, rowLen);
            }
            return true;
        }
        return false;
    }

    @Override
    public Object getObject() throws Exception {
        return this.currentNull ? null : this.getDecimal();
    }

    @Override
    public Decimal getDecimal() throws Exception {
        return this.currentValue;
    }

    @Override
    public long getLong() throws Exception {
        assert (!this.currentNull);
        if (null == this.currentValue.getBigUnscaled()) {
            if (0 == this.currentValue.getScale()) {
                return this.currentValue.getUnscaled();
            }
            return this.currentValue.getUnscaled() / (long)Math.pow(10.0, this.currentValue.getUnscaled());
        }
        if (0 == this.currentValue.getScale()) {
            return this.currentValue.getBigUnscaled().longValue();
        }
        StringBuilder builder = new StringBuilder("1");
        for (int i = 0; i < this.currentValue.getScale(); ++i) {
            builder.append('0');
        }
        return this.currentValue.getBigUnscaled().divide(new BigInteger(builder.toString())).longValue();
    }

    @Override
    public float getFloat() throws Exception {
        assert (!this.currentNull);
        if (null == this.currentValue.getBigUnscaled()) {
            if (0 == this.currentValue.getScale()) {
                return this.currentValue.getUnscaled();
            }
            return (float)this.currentValue.getUnscaled() / (float)Math.pow(10.0, this.currentValue.getUnscaled());
        }
        if (0 == this.currentValue.getScale()) {
            return this.currentValue.getBigUnscaled().floatValue();
        }
        return new BigDecimal(this.currentValue.getBigUnscaled(), this.currentValue.getScale()).floatValue();
    }

    @Override
    public double getDouble() throws Exception {
        assert (!this.currentNull);
        if (null == this.currentValue.getBigUnscaled()) {
            if (0 == this.currentValue.getScale()) {
                return this.currentValue.getUnscaled();
            }
            return (double)this.currentValue.getUnscaled() / Math.pow(10.0, this.currentValue.getScale());
        }
        if (0 == this.currentValue.getScale()) {
            return this.currentValue.getBigUnscaled().doubleValue();
        }
        return new BigDecimal(this.currentValue.getBigUnscaled(), this.currentValue.getScale()).doubleValue();
    }

    @Override
    public Slice getString() throws Exception {
        if (this.currentNull) {
            return null;
        }
        String str = null == this.currentValue.getBigUnscaled() ? (0 == this.currentValue.getScale() ? Long.toString(this.currentValue.getUnscaled()) : new BigDecimal(BigInteger.valueOf(this.currentValue.getUnscaled()), this.currentValue.getScale()).toString()) : (0 == this.currentValue.getScale() ? this.currentValue.getBigUnscaled().toString() : new BigDecimal(this.currentValue.getBigUnscaled(), this.currentValue.getScale()).toString());
        byte[] bytes = str.getBytes();
        return new Slice(bytes, 0, bytes.length);
    }
}

