/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result.chunk.block;

import com.alibaba.polardbx.rpc.result.chunk.AbstractBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.Decimal;
import com.alibaba.polardbx.rpc.result.chunk.Slice;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.math.BigDecimal;

public class DoubleBlockDecoder
extends AbstractBlockDecoder {
    private double currentValue = 0.0;

    public DoubleBlockDecoder(PolarxResultset.Chunk chunk, int columnIndex, PolarxResultset.ColumnMetaData meta) {
        super(chunk, columnIndex, meta);
    }

    @Override
    public boolean next() throws Exception {
        boolean hasNext = super.next();
        if (hasNext) {
            this.currentValue = this.currentNull ? 0.0 : this.stream.readDouble();
            return true;
        }
        return false;
    }

    @Override
    public Object getObject() throws Exception {
        return this.currentNull ? null : Double.valueOf(this.getDouble());
    }

    @Override
    public double getDouble() throws Exception {
        assert (!this.currentNull);
        return this.currentValue;
    }

    @Override
    public long getLong() throws Exception {
        assert (!this.currentNull);
        return (long)this.currentValue;
    }

    @Override
    public float getFloat() throws Exception {
        assert (!this.currentNull);
        return (float)this.currentValue;
    }

    @Override
    public Decimal getDecimal() throws Exception {
        if (this.currentNull) {
            return null;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(this.currentValue);
        return new Decimal(bigDecimal.unscaledValue(), bigDecimal.scale());
    }

    @Override
    public Slice getString() throws Exception {
        if (this.currentNull) {
            return null;
        }
        String str = Double.toString(this.currentValue);
        byte[] bytes = str.getBytes();
        return new Slice(bytes, 0, bytes.length);
    }
}

