/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result.chunk.block;

import com.alibaba.polardbx.rpc.result.chunk.AbstractBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.Decimal;
import com.alibaba.polardbx.rpc.result.chunk.Slice;
import com.mysql.cj.polarx.protobuf.PolarxResultset;

public class LongBlockDecoder
extends AbstractBlockDecoder {
    private long currentValue = 0L;

    public LongBlockDecoder(PolarxResultset.Chunk chunk, int columnIndex, PolarxResultset.ColumnMetaData meta) {
        super(chunk, columnIndex, meta);
    }

    @Override
    public boolean next() throws Exception {
        boolean hasNext = super.next();
        if (hasNext) {
            this.currentValue = this.currentNull ? 0L : this.stream.readInt64();
            return true;
        }
        return false;
    }

    @Override
    public Object getObject() throws Exception {
        return this.currentNull ? null : Long.valueOf(this.getLong());
    }

    @Override
    public long getLong() throws Exception {
        assert (!this.currentNull);
        return this.currentValue;
    }

    @Override
    public float getFloat() throws Exception {
        assert (!this.currentNull);
        return this.currentValue;
    }

    @Override
    public double getDouble() throws Exception {
        assert (!this.currentNull);
        return this.currentValue;
    }

    @Override
    public Decimal getDecimal() throws Exception {
        if (this.currentNull) {
            return null;
        }
        return new Decimal(this.currentValue, 0);
    }

    @Override
    public Slice getString() throws Exception {
        if (this.currentNull) {
            return null;
        }
        String str = Long.toUnsignedString(this.currentValue);
        byte[] bytes = str.getBytes();
        return new Slice(bytes, 0, bytes.length);
    }
}

