/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result.chunk.block;

import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.rpc.result.chunk.AbstractBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.Slice;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.util.ArrayList;
import java.util.List;

public class SetBlockDecoder
extends AbstractBlockDecoder {
    private List<Slice> currentValue = null;

    public SetBlockDecoder(PolarxResultset.Chunk chunk, int columnIndex, PolarxResultset.ColumnMetaData meta) {
        super(chunk, columnIndex, meta);
    }

    @Override
    public boolean next() throws Exception {
        boolean hasNext = super.next();
        if (hasNext) {
            if (this.currentNull) {
                this.currentValue = null;
            } else {
                int totalLength = this.stream.readInt32();
                if (totalLength <= 0) {
                    throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Read chunk set more than 2G."});
                }
                if (1 == totalLength) {
                    this.stream.skipRawBytes(totalLength);
                    this.currentValue = new ArrayList<Slice>();
                } else {
                    int limit = this.stream.getTotalBytesRead() + totalLength;
                    if (limit <= this.stream.getTotalBytesRead()) {
                        throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Set chunk overflow."});
                    }
                    this.currentValue = new ArrayList<Slice>();
                    while (this.stream.getTotalBytesRead() < limit) {
                        int len = (int)this.stream.readInt64();
                        this.currentValue.add(new Slice(this.stream.readRawBytes(len), 0, len));
                    }
                }
            }
            return true;
        }
        this.currentNull = true;
        this.currentValue = null;
        return false;
    }

    @Override
    public Object getObject() throws Exception {
        return this.currentNull ? null : this.getSet();
    }

    @Override
    public List<Slice> getSet() throws Exception {
        return this.currentValue;
    }

    @Override
    public Slice getString() throws Exception {
        if (this.currentNull) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Slice slice : this.currentValue) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(slice.toString());
        }
        String str = builder.toString();
        byte[] bytes = str.getBytes();
        return new Slice(bytes, 0, bytes.length);
    }
}

