/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result.chunk.block;

import com.alibaba.polardbx.common.exception.TddlRuntimeException;
import com.alibaba.polardbx.common.exception.code.ErrorCode;
import com.alibaba.polardbx.common.utils.time.core.MysqlDateTime;
import com.alibaba.polardbx.common.utils.time.core.TimeStorage;
import com.alibaba.polardbx.common.utils.time.parser.StringTimeParser;
import com.alibaba.polardbx.rpc.result.chunk.AbstractBlockDecoder;
import com.alibaba.polardbx.rpc.result.chunk.Decimal;
import com.alibaba.polardbx.rpc.result.chunk.Slice;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.math.BigDecimal;

public class StringBlockDecoder
extends AbstractBlockDecoder {
    private Slice currentValue = null;

    public StringBlockDecoder(PolarxResultset.Chunk chunk, int columnIndex, PolarxResultset.ColumnMetaData meta) {
        super(chunk, columnIndex, meta);
    }

    @Override
    public boolean next() throws Exception {
        boolean hasNext = super.next();
        if (hasNext) {
            if (this.currentNull) {
                this.currentValue = null;
            } else {
                int length = this.stream.readInt32();
                if (length <= 0) {
                    throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Read chunk string more than 2G."});
                }
                this.currentValue = new Slice(this.stream.readRawBytes(length - 1), 0, length - 1);
                this.stream.skipRawBytes(1);
            }
            return true;
        }
        return false;
    }

    @Override
    public Object getObject() throws Exception {
        return this.currentNull ? null : this.getString();
    }

    @Override
    public Slice getString() throws Exception {
        return this.currentValue;
    }

    @Override
    public long getLong() throws Exception {
        int sign = 1;
        long val = 0L;
        for (int i = 0; i < this.currentValue.getLength(); ++i) {
            byte b = this.currentValue.getData()[this.currentValue.getOffset() + i];
            if (0 == i && 45 == b) {
                sign = -1;
                continue;
            }
            if (b >= 48 && b <= 57) {
                val = 10L * val + (long)(b - 48);
                continue;
            }
            throw new TddlRuntimeException(ErrorCode.ERR_X_PROTOCOL_RESULT, new String[]{"Bad string to long."});
        }
        return (long)sign * val;
    }

    @Override
    public float getFloat() throws Exception {
        return Float.parseFloat(this.currentValue.toString());
    }

    @Override
    public double getDouble() throws Exception {
        return Double.parseDouble(this.currentValue.toString());
    }

    @Override
    public long getDate() throws Exception {
        byte[] bytes = new byte[this.currentValue.getLength()];
        System.arraycopy(this.currentValue.getData(), this.currentValue.getOffset(), bytes, 0, this.currentValue.getLength());
        MysqlDateTime t = StringTimeParser.parseString((byte[])bytes, (int)91);
        return TimeStorage.writeDate((MysqlDateTime)t);
    }

    @Override
    public long getBit() throws Exception {
        return Long.parseLong(this.currentValue.toString(), 2);
    }

    @Override
    public long getTime() throws Exception {
        byte[] bytes = new byte[this.currentValue.getLength()];
        System.arraycopy(this.currentValue.getData(), this.currentValue.getOffset(), bytes, 0, this.currentValue.getLength());
        MysqlDateTime t = StringTimeParser.parseString((byte[])bytes, (int)92);
        return TimeStorage.writeTime((MysqlDateTime)t);
    }

    @Override
    public long getDatetime() throws Exception {
        byte[] bytes = new byte[this.currentValue.getLength()];
        System.arraycopy(this.currentValue.getData(), this.currentValue.getOffset(), bytes, 0, this.currentValue.getLength());
        MysqlDateTime t = StringTimeParser.parseString((byte[])bytes, (int)93);
        return TimeStorage.writeTimestamp((MysqlDateTime)t);
    }

    @Override
    public Decimal getDecimal() throws Exception {
        BigDecimal bigDecimal = new BigDecimal(this.currentValue.toString());
        return new Decimal(bigDecimal.unscaledValue(), bigDecimal.scale());
    }
}

