/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.result.chunk.block;

import com.alibaba.polardbx.rpc.result.chunk.Decimal;
import com.alibaba.polardbx.rpc.result.chunk.Slice;
import com.alibaba.polardbx.rpc.result.chunk.block.LongBlockDecoder;
import com.mysql.cj.polarx.protobuf.PolarxResultset;
import java.sql.Time;
import java.util.TimeZone;

public class TimeBlockDecoder
extends LongBlockDecoder {
    private TimeZone timeZone = TimeZone.getDefault();

    public TimeBlockDecoder(PolarxResultset.Chunk chunk, int columnIndex, PolarxResultset.ColumnMetaData meta) {
        super(chunk, columnIndex, meta);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Object getObject() throws Exception {
        return this.currentNull ? null : TimeBlockDecoder.longToTime(this.getTime(), this.timeZone);
    }

    @Override
    public long getTime() throws Exception {
        assert (!this.currentNull);
        return super.getLong();
    }

    @Override
    public long getLong() throws Exception {
        assert (!this.currentNull);
        return TimeBlockDecoder.longToTime(this.getTime(), this.timeZone).getTime();
    }

    @Override
    public float getFloat() throws Exception {
        assert (!this.currentNull);
        return this.getLong();
    }

    @Override
    public double getDouble() throws Exception {
        assert (!this.currentNull);
        return this.getLong();
    }

    @Override
    public long getDate() throws Exception {
        assert (!this.currentNull);
        return super.getLong();
    }

    @Override
    public long getDatetime() throws Exception {
        assert (!this.currentNull);
        return super.getLong();
    }

    @Override
    public Decimal getDecimal() throws Exception {
        if (this.currentNull) {
            return null;
        }
        return new Decimal(this.getLong(), 0);
    }

    @Override
    public Slice getString() throws Exception {
        if (this.currentNull) {
            return null;
        }
        String str = TimeBlockDecoder.longToString(this.getDate());
        byte[] bytes = str.getBytes();
        return new Slice(bytes, 0, bytes.length);
    }

    public static String longToString(long time) {
        boolean negative = time < 0L;
        if (negative) {
            time = -time;
        }
        long micros = time % 0x1000000L;
        long ymdhms = time >> 24;
        long hms = ymdhms % 131072L;
        long second = hms % 64L;
        long minute = (hms >> 6) % 64L;
        long hour = hms >> 12;
        return String.format("%s%02d:%02d:%02d.%06d", negative ? "-" : "", hour, minute, second, micros);
    }

    public static Time longToTime(long time, TimeZone tz) {
        boolean negative = time < 0L;
        if (negative) {
            time = -time;
        }
        long micros = time % 0x1000000L;
        long ymdhms = time >> 24;
        long hms = ymdhms % 131072L;
        long second = hms % 64L;
        long minute = (hms >> 6) % 64L;
        long hour = hms >> 12;
        return new Time((long)(-tz.getRawOffset()) + (long)(negative ? -1 : 1) * (hour * 3600000L + minute * 60000L + second * 1000L + micros / 1000L));
    }
}

