/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.rpc.utils;

import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class NotifyQueue<E> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Queue<E> queue = new ConcurrentLinkedQueue();
    private final AtomicInteger count = new AtomicInteger(0);

    private void signal() {
        this.lock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void put(E e) {
        this.queue.offer(e);
        if (0 == this.count.getAndIncrement()) {
            this.signal();
        }
    }

    public void put(Collection<? extends E> c) {
        for (E e : c) {
            this.queue.offer(e);
        }
        if (0 == this.count.getAndAdd(c.size())) {
            this.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E e = this.queue.poll();
        if (e != null) {
            this.count.getAndDecrement();
        } else if (timeout > 0L) {
            long nanos = unit.toNanos(timeout);
            this.lock.lockInterruptibly();
            try {
                while (null == (e = this.queue.poll())) {
                    if (nanos <= 0L) {
                        E e2 = null;
                        return e2;
                    }
                    if (0 != this.count.get()) continue;
                    nanos = this.notEmpty.awaitNanos(nanos);
                }
                long c = this.count.getAndDecrement();
                if (c > 1L) {
                    this.notEmpty.signal();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return e;
    }

    public int count() {
        return this.count.get();
    }
}

