/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class TransmittableThreadLocal<T>
extends InheritableThreadLocal<T> {
    static ThreadLocal<Map<TransmittableThreadLocal<?>, ?>> holder = new ThreadLocal<Map<TransmittableThreadLocal<?>, ?>>(){

        @Override
        protected Map<TransmittableThreadLocal<?>, ?> initialValue() {
            return new WeakHashMap();
        }
    };

    protected T copy(T parentValue) {
        return parentValue;
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    @Override
    public final T get() {
        Object value = super.get();
        if (null != value) {
            this.addValue();
        }
        return value;
    }

    @Override
    public final void set(T value) {
        super.set(value);
        if (null == value) {
            this.removeValue();
        } else {
            this.addValue();
        }
    }

    @Override
    public final void remove() {
        this.removeValue();
        super.remove();
    }

    private void superRemove() {
        super.remove();
    }

    T copyValue() {
        return this.copy(this.get());
    }

    void addValue() {
        if (!holder.get().containsKey(this)) {
            holder.get().put(this, null);
        }
    }

    void removeValue() {
        holder.get().remove(this);
    }

    static Map<TransmittableThreadLocal<?>, Object> copy() {
        HashMap copy = new HashMap();
        for (TransmittableThreadLocal<?> threadLocal : holder.get().keySet()) {
            copy.put(threadLocal, threadLocal.copyValue());
        }
        return copy;
    }

    static Map<TransmittableThreadLocal<?>, Object> backupAndSet(Map<TransmittableThreadLocal<?>, Object> copied) {
        TransmittableThreadLocal<?> threadLocal;
        HashMap backup = new HashMap();
        Iterator<Map.Entry<TransmittableThreadLocal<?>, ?>> iterator = holder.get().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TransmittableThreadLocal<?>, ?> next = iterator.next();
            threadLocal = next.getKey();
            backup.put(threadLocal, threadLocal.get());
            if (copied.containsKey(threadLocal)) continue;
            iterator.remove();
            super.superRemove();
        }
        for (Map.Entry<TransmittableThreadLocal<?>, Object> entry : copied.entrySet()) {
            threadLocal = entry.getKey();
            threadLocal.set(entry.getValue());
        }
        TransmittableThreadLocal.doExecuteCallback(true);
        return backup;
    }

    static void restore(Map<TransmittableThreadLocal<?>, Object> backup) {
        TransmittableThreadLocal<?> threadLocal;
        TransmittableThreadLocal.doExecuteCallback(false);
        Iterator<Map.Entry<TransmittableThreadLocal<?>, ?>> iterator = holder.get().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TransmittableThreadLocal<?>, ?> next = iterator.next();
            threadLocal = next.getKey();
            if (backup.containsKey(threadLocal)) continue;
            iterator.remove();
            super.superRemove();
        }
        for (Map.Entry<TransmittableThreadLocal<?>, Object> entry : backup.entrySet()) {
            threadLocal = entry.getKey();
            threadLocal.set(entry.getValue());
        }
    }

    private static void doExecuteCallback(boolean isBefore) {
        for (Map.Entry<TransmittableThreadLocal<?>, ?> entry : holder.get().entrySet()) {
            TransmittableThreadLocal<?> threadLocal = entry.getKey();
            try {
                if (isBefore) {
                    threadLocal.beforeExecute();
                    continue;
                }
                threadLocal.afterExecute();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

