/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool;

import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.spi.TtlWrapper;
import com.alibaba.ttl.threadpool.DisableInheritableThreadFactory;
import com.alibaba.ttl.threadpool.DisableInheritableThreadFactoryWrapper;
import com.alibaba.ttl.threadpool.ExecutorServiceTtlWrapper;
import com.alibaba.ttl.threadpool.ExecutorTtlWrapper;
import com.alibaba.ttl.threadpool.ScheduledExecutorServiceTtlWrapper;
import com.alibaba.ttl.threadpool.agent.TtlAgent;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public final class TtlExecutors {
    @Nullable
    public static Executor getTtlExecutor(@Nullable Executor executor) {
        if (TtlAgent.isTtlAgentLoaded() || null == executor || executor instanceof TtlEnhanced) {
            return executor;
        }
        return new ExecutorTtlWrapper(executor, true);
    }

    @Nullable
    public static ExecutorService getTtlExecutorService(@Nullable ExecutorService executorService) {
        if (TtlAgent.isTtlAgentLoaded() || executorService == null || executorService instanceof TtlEnhanced) {
            return executorService;
        }
        return new ExecutorServiceTtlWrapper(executorService, true);
    }

    @Nullable
    public static ScheduledExecutorService getTtlScheduledExecutorService(@Nullable ScheduledExecutorService scheduledExecutorService) {
        if (TtlAgent.isTtlAgentLoaded() || scheduledExecutorService == null || scheduledExecutorService instanceof TtlEnhanced) {
            return scheduledExecutorService;
        }
        return new ScheduledExecutorServiceTtlWrapper(scheduledExecutorService, true);
    }

    public static <T extends Executor> boolean isTtlWrapper(@Nullable T executor) {
        return executor instanceof TtlWrapper;
    }

    @Nullable
    public static <T extends Executor> T unwrap(@Nullable T executor) {
        if (!TtlExecutors.isTtlWrapper(executor)) {
            return executor;
        }
        return (T)((ExecutorTtlWrapper)executor).unwrap();
    }

    @Nullable
    public static ThreadFactory getDisableInheritableThreadFactory(@Nullable ThreadFactory threadFactory) {
        if (threadFactory == null || TtlExecutors.isDisableInheritableThreadFactory(threadFactory)) {
            return threadFactory;
        }
        return new DisableInheritableThreadFactoryWrapper(threadFactory);
    }

    @NonNull
    public static ThreadFactory getDefaultDisableInheritableThreadFactory() {
        return TtlExecutors.getDisableInheritableThreadFactory(Executors.defaultThreadFactory());
    }

    public static boolean isDisableInheritableThreadFactory(@Nullable ThreadFactory threadFactory) {
        return threadFactory instanceof DisableInheritableThreadFactory;
    }

    @Nullable
    public static ThreadFactory unwrap(@Nullable ThreadFactory threadFactory) {
        if (!TtlExecutors.isDisableInheritableThreadFactory(threadFactory)) {
            return threadFactory;
        }
        return ((DisableInheritableThreadFactory)threadFactory).unwrap();
    }

    private TtlExecutors() {
    }
}

