/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim;

import com.alibaba.ververica.connectors.common.dim.RuntimeContextWrapper;
import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.util.Collector;

public class LookupFunctionWrapper
extends TableFunction<RowData> {
    private static final long serialVersionUID = 6941593589582551911L;
    private final FlatMapFunction<RowData, RowData> fetcher;
    private final Collector<RowData> collector;

    public LookupFunctionWrapper(FlatMapFunction<RowData, RowData> fetcher) {
        this.fetcher = fetcher;
        this.collector = new CollectorWrapper();
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)new RuntimeContextWrapper(context));
        FunctionUtils.openFunction(this.fetcher, (OpenContext)new DefaultOpenContext());
    }

    public void eval(Object ... inputs) throws Exception {
        GenericRowData row = GenericRowData.of((Object[])inputs);
        this.fetcher.flatMap((Object)row, this.collector);
    }

    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.fetcher);
    }

    @VisibleForTesting
    public FlatMapFunction<RowData, RowData> getFetcher() {
        return this.fetcher;
    }

    private class CollectorWrapper
    implements Collector<RowData>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CollectorWrapper() {
        }

        public void collect(RowData baseRow) {
            LookupFunctionWrapper.this.collect(baseRow);
        }

        public void close() {
        }
    }
}

