/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim.cache;

import com.alibaba.ververica.connectors.common.dim.cache.AllCache;
import com.alibaba.ververica.connectors.common.util.MemoryPool;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;

public class BinaryAllCacheBase<V>
extends AllCache<Object, V> {
    protected final RowDataSerializer keySer;
    protected final RowDataSerializer valSer;
    private transient SimpleCollectingOutputView outView;
    private transient RandomAccessInputView inView;

    public BinaryAllCacheBase(RowDataSerializer keySer, RowDataSerializer valSer) {
        this.keySer = keySer;
        this.valSer = valSer;
    }

    @Override
    public void startNewCache() {
        super.startNewCache();
        ArrayList segments = new ArrayList();
        this.outView = new SimpleCollectingOutputView(segments, (MemorySegmentSource)new MemoryPool(), 32768);
        this.inView = new RandomAccessInputView(segments, 32768);
    }

    protected RowData keyToBinary(RowData key) throws IOException {
        long oldPosition = this.outView.getCurrentOffset();
        int skip = this.keySer.serializeToPages(key, (AbstractPagedOutputView)this.outView);
        this.inView.setReadPosition(oldPosition + (long)skip);
        key = this.keySer.mapFromPages(key, (AbstractPagedInputView)this.inView);
        return key;
    }

    protected RowData valToBinary(RowData value) throws IOException {
        BinaryRowData bVal = new BinaryRowData(value.getArity());
        long oldPosition = this.outView.getCurrentOffset();
        int skip = this.valSer.serializeToPages(value, (AbstractPagedOutputView)this.outView);
        this.inView.setReadPosition(oldPosition + (long)skip);
        value = this.valSer.mapFromPages((RowData)bVal, (AbstractPagedInputView)this.inView);
        return value;
    }
}

