/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim.cache;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.util.Preconditions;

public class CacheStrategy
implements Serializable {
    private static final long serialVersionUID = 5393301909928230796L;
    private final long size;
    private final long ttlMs;
    private final boolean cacheEmpty;
    private final boolean cacheAll;
    private final boolean binaryCacheEnabled;
    private final boolean isRecordingStats;

    private CacheStrategy(long size, long ttlMs) {
        this(size, ttlMs, false, true);
    }

    private CacheStrategy(long size, long ttlMs, boolean isRecordingStats, boolean cacheEmpty) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size must be greater or equal to zero");
        Preconditions.checkArgument((ttlMs >= 0L ? 1 : 0) != 0, (Object)"ttlMs must be greater or equal to zero");
        this.size = size;
        this.ttlMs = ttlMs;
        this.cacheAll = false;
        this.cacheEmpty = cacheEmpty;
        this.isRecordingStats = isRecordingStats;
        this.binaryCacheEnabled = false;
    }

    private CacheStrategy(boolean cacheAll, long ttlMs) {
        this(cacheAll, false, ttlMs);
    }

    private CacheStrategy(boolean cacheAll, boolean binaryCacheEnabled, long ttlMs) {
        this.cacheAll = cacheAll;
        this.ttlMs = ttlMs;
        this.size = -1L;
        this.isRecordingStats = false;
        this.cacheEmpty = false;
        this.binaryCacheEnabled = binaryCacheEnabled;
    }

    public boolean isRecordingStats() {
        return this.isRecordingStats;
    }

    public long getSize() {
        return this.size;
    }

    public long getTtlMs() {
        return this.ttlMs;
    }

    public boolean isNoCache() {
        return this.size == 0L || this.ttlMs == 0L;
    }

    public boolean isNeverExpired() {
        return this.ttlMs == Long.MAX_VALUE;
    }

    public boolean isAllCache() {
        return this.cacheAll;
    }

    public boolean isBinaryCacheEnabled() {
        return this.binaryCacheEnabled;
    }

    public boolean isCacheEmpty() {
        return this.cacheEmpty;
    }

    public static CacheStrategy lru(long cacheSize, long ttlMs, boolean isRecordingStats, boolean cacheEmpty) {
        return new CacheStrategy(cacheSize, ttlMs, isRecordingStats, cacheEmpty);
    }

    public static CacheStrategy lru(long cacheSize, long ttlMs, boolean isRecordingStats) {
        return new CacheStrategy(cacheSize, ttlMs, isRecordingStats, true);
    }

    public static CacheStrategy none() {
        return new CacheStrategy(0L, 0L);
    }

    public static CacheStrategy neverExpired(long cacheSize, boolean isRecordingStats, boolean cacheEmpty) {
        return new CacheStrategy(cacheSize, Long.MAX_VALUE, isRecordingStats, cacheEmpty);
    }

    public static CacheStrategy neverExpired(long cacheSize, boolean isRecordingStats) {
        return new CacheStrategy(cacheSize, Long.MAX_VALUE, isRecordingStats, true);
    }

    public static CacheStrategy all(long ttlMs) {
        return new CacheStrategy(true, ttlMs);
    }

    public static CacheStrategy all(boolean binaryCacheEnabled, long ttlMs) {
        return new CacheStrategy(true, binaryCacheEnabled, ttlMs);
    }

    public static CacheStrategy all() {
        return new CacheStrategy(true, Long.MAX_VALUE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheStrategy that = (CacheStrategy)o;
        return this.size == that.size && this.ttlMs == that.ttlMs && this.cacheEmpty == that.cacheEmpty && this.cacheAll == that.cacheAll && this.isRecordingStats == that.isRecordingStats;
    }

    public int hashCode() {
        return Objects.hash(this.size, this.ttlMs, this.isCacheEmpty(), this.cacheAll, this.isRecordingStats);
    }

    public String toString() {
        return "CacheStrategy{size=" + this.size + ", ttlMs=" + this.ttlMs + ", cacheEmpty=" + this.cacheEmpty + ", cacheAll=" + this.cacheAll + ", isRecordingStats=" + this.isRecordingStats + "}";
    }
}

