/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim.cache;

import com.alibaba.ververica.connectors.common.dim.cache.Cache;
import java.util.concurrent.TimeUnit;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.ThreadSafeSimpleCounter;
import org.apache.flink.metrics.groups.CacheMetricGroup;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheBuilder;

public class LRUCache<K, V>
implements Cache<K, V> {
    private final org.apache.flink.shaded.guava31.com.google.common.cache.Cache<K, V> cache;
    private transient Counter hitCounter;
    private transient Counter missCounter;

    public LRUCache(long cacheSize, boolean isRecordingStats) {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize(cacheSize);
        if (isRecordingStats) {
            builder = builder.recordStats();
        }
        this.cache = builder.build();
    }

    public LRUCache(long cacheSize, long ttlMs, boolean isRecordingStats) {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize(cacheSize).expireAfterWrite(ttlMs, TimeUnit.MILLISECONDS);
        if (isRecordingStats) {
            builder = builder.recordStats();
        }
        this.cache = builder.build();
    }

    @Override
    public void open(CacheMetricGroup metricGroup) {
        if (this.hitCounter == null) {
            this.hitCounter = new ThreadSafeSimpleCounter();
        }
        if (this.missCounter == null) {
            this.missCounter = new ThreadSafeSimpleCounter();
        }
        metricGroup.hitCounter(this.hitCounter);
        metricGroup.missCounter(this.missCounter);
        metricGroup.numCachedRecordsGauge(this::size);
    }

    @Override
    public V get(K key) {
        Object value = this.cache.getIfPresent(key);
        if (value != null) {
            this.hitCounter.inc();
        } else {
            this.missCounter.inc();
        }
        return (V)value;
    }

    @Override
    public void put(K key, V row) {
        this.cache.put(key, row);
    }

    @Override
    public void remove(K key) {
        this.cache.invalidate(key);
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    public double hitRate() {
        return this.cache.stats().hitRate();
    }
}

