/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.meta;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;

public interface ConnectorMetadataFactory {
    public String propertiesIdentifier();

    default public String getGroupId() {
        return Utils.retrieveProperty(this.getClass().getClassLoader(), this.propertiesIdentifier(), "groupId");
    }

    default public String getArtifactId() {
        return Utils.retrieveProperty(this.getClass().getClassLoader(), this.propertiesIdentifier(), "artifactId");
    }

    default public String getType() {
        return "jar";
    }

    default public String getVersion() {
        return Utils.retrieveProperty(this.getClass().getClassLoader(), this.propertiesIdentifier(), "version");
    }

    default public Boolean runtimeBundled() {
        return true;
    }

    default public String runtimeClassifier() {
        return "jar-with-dependencies";
    }

    default public String getRuntimeArtifactFileName() {
        if (this.runtimeBundled().booleanValue()) {
            return String.format("%s-%s.%s", this.getArtifactId(), this.getVersion(), this.getType());
        }
        return String.format("%s-%s-%s.%s", this.getArtifactId(), this.getVersion(), this.runtimeClassifier(), this.getType());
    }

    public static class Utils {
        public static String retrieveProperty(ClassLoader classLoader, String propertiesIdentifier, String propertyKey) {
            String string;
            block9: {
                String propertiesFile = String.format("META-INF/%s.properties", propertiesIdentifier);
                InputStream propertiesStream = classLoader.getResourceAsStream(propertiesFile);
                try {
                    if (propertiesStream == null) {
                        throw new FileNotFoundException(propertiesFile + " not found in classpath");
                    }
                    Properties properties = new Properties();
                    properties.load(propertiesStream);
                    string = properties.getProperty(propertyKey);
                    if (propertiesStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (propertiesStream != null) {
                            try {
                                propertiesStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                propertiesStream.close();
            }
            return string;
        }
    }
}

