/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source.resolver.parse;

import com.alibaba.ververica.connectors.common.util.ByteSerializer;
import java.util.Arrays;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.variant.Variant;
import org.apache.flink.util.StringUtils;

public class BufferedTextRowData
implements RowData {
    private final int arity;
    private RowKind rowKind;
    private final boolean[] isNull;
    private final int[] starts;
    private final int[] lengths;
    private final Object[] fields;
    private byte[] buffer;
    private MemorySegment[] segments;

    public BufferedTextRowData(ByteSerializer.ValueType[] fieldTypes) {
        this(fieldTypes, RowKind.INSERT);
    }

    public BufferedTextRowData(ByteSerializer.ValueType[] fieldTypes, RowKind rowKind) {
        this.arity = fieldTypes.length;
        this.rowKind = rowKind;
        this.isNull = new boolean[this.arity];
        this.starts = new int[this.arity];
        this.lengths = new int[this.arity];
        this.fields = new Object[this.arity];
    }

    public int getArity() {
        return this.arity;
    }

    public RowKind getRowKind() {
        return this.rowKind;
    }

    public void setRowKind(RowKind rowKind) {
        this.rowKind = rowKind;
    }

    public boolean isNullAt(int pos) {
        return this.isNull[pos];
    }

    public boolean getBoolean(int pos) {
        return (Boolean)this.fields[pos];
    }

    public byte getByte(int pos) {
        return (Byte)this.fields[pos];
    }

    public short getShort(int pos) {
        return (Short)this.fields[pos];
    }

    public int getInt(int pos) {
        return (Integer)this.fields[pos];
    }

    public long getLong(int pos) {
        return (Long)this.fields[pos];
    }

    public float getFloat(int pos) {
        return ((Float)this.fields[pos]).floatValue();
    }

    public double getDouble(int pos) {
        return (Double)this.fields[pos];
    }

    public StringData getString(int pos) {
        return BinaryStringData.fromAddress((MemorySegment[])this.segments, (int)this.starts[pos], (int)this.lengths[pos]);
    }

    public DecimalData getDecimal(int pos, int precision, int scale) {
        return (DecimalData)this.fields[pos];
    }

    public TimestampData getTimestamp(int pos, int precision) {
        return (TimestampData)this.fields[pos];
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        throw new UnsupportedOperationException();
    }

    public byte[] getBinary(int pos) {
        byte[] copy = new byte[this.lengths[pos]];
        System.arraycopy(this.buffer, this.starts[pos], copy, 0, this.lengths[pos]);
        return copy;
    }

    public ArrayData getArray(int pos) {
        throw new UnsupportedOperationException();
    }

    public MapData getMap(int pos) {
        throw new UnsupportedOperationException();
    }

    public RowData getRow(int pos, int numFields) {
        throw new UnsupportedOperationException();
    }

    public Variant getVariant(int pos) {
        throw new UnsupportedOperationException();
    }

    public void setNullAt(int pos) {
        this.isNull[pos] = true;
    }

    public void setAllFieldsToNull() {
        Arrays.fill(this.isNull, true);
    }

    public void setNotNullAt(int pos) {
        this.isNull[pos] = false;
    }

    public int getStart(int pos) {
        return this.starts[pos];
    }

    public int getLength(int pos) {
        return this.lengths[pos];
    }

    public void setPointersAt(int pos, int start, int length) {
        this.starts[pos] = start;
        this.lengths[pos] = length;
    }

    public void setField(int pos, Object value) {
        if (value == null) {
            this.setNullAt(pos);
        } else {
            this.setNotNullAt(pos);
            this.fields[pos] = value;
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void replaceBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.segments = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])buffer)};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rowKind.shortString()).append("(");
        for (int i = 0; i < this.fields.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            if (this.fields[i] != null) {
                sb.append(StringUtils.arrayAwareToString((Object)this.fields[i]));
                continue;
            }
            sb.append(new String(this.buffer, this.starts[i], this.lengths[i]));
        }
        sb.append(")");
        return sb.toString();
    }
}

