/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.sts;

import com.alibaba.ververica.connectors.common.sts.StsCredentialProvider;
import com.alibaba.ververica.connectors.common.sts.StsOptions;
import com.alibaba.ververica.connectors.common.sts.StsServiceRequest;
import com.alibaba.ververica.connectors.common.sts.VervericaStsCredentialProvider;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheLoader;
import org.apache.flink.shaded.guava31.com.google.common.cache.LoadingCache;
import org.apache.flink.shaded.guava31.com.google.common.util.concurrent.UncheckedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientProvider<T> {
    public static final int DEFAULT_STS_EXPIRE_SECOND = 86400;
    private static Logger logger = LoggerFactory.getLogger(AbstractClientProvider.class);
    private static LoadingCache<String, InnerStsIdentity> cacheArnResponse = null;
    private static long lastCertificationUpdateTime = 0L;
    private static final Object MUTEX = new Object();
    private static int stsExpireSeconds = 86400;
    protected T client;
    private String accessId = null;
    private String accessKey = null;
    private String stsRoleArn = null;
    private String stsAccessId = null;
    private String stsAccessKey = null;
    private String stsSessionName = null;
    private String stsAssumeRoleFor = null;
    private boolean useSts;
    private long lastUpdateTime = 0L;

    public AbstractClientProvider(String accessId, String accessKey, Configuration properties) {
        if (accessId != null && accessKey != null) {
            this.useAKAuthentication(accessId, accessKey);
            return;
        }
        this.useStsAuthentication(properties);
    }

    public AbstractClientProvider(StsCredentialProvider stsCredentialProvider) {
        this.useSts = true;
        this.setCacheLoader(stsCredentialProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCacheLoader(StsCredentialProvider stsCredentialProvider) {
        Object object = MUTEX;
        synchronized (object) {
            cacheArnResponse = CacheBuilder.newBuilder().concurrencyLevel(5).initialCapacity(1).maximumSize(3L).expireAfterWrite((long)stsExpireSeconds, TimeUnit.SECONDS).build((CacheLoader)new StsIdentityLoader(stsCredentialProvider));
        }
    }

    private void useStsAuthentication(Configuration properties) {
        this.useSts = true;
        this.stsRoleArn = properties.getString(StsOptions.STS.STS_ROLE_ARN);
        this.stsAccessId = properties.getString(StsOptions.STS.STS_ACCESS_ID);
        this.stsAccessKey = properties.getString(StsOptions.STS.STS_ACCESS_KEY);
        if (this.stsRoleArn != null && this.stsAccessId != null && this.stsAccessKey != null) {
            this.stsAssumeRoleFor = properties.getString(StsOptions.STS.STS_UID);
            this.stsSessionName = UUID.randomUUID().toString().replace("-", "");
            stsExpireSeconds = properties.getInteger(StsOptions.STS.STS_ROLEARN_UPDATE_SECONDS);
            this.setCacheLoader(new DefaultStsCredentialProvider(this, properties));
            return;
        }
        this.setCacheLoader(new VervericaStsCredentialProvider());
    }

    private void useAKAuthentication(String accessId, String accessKey) {
        this.accessId = accessId;
        this.accessKey = accessKey;
        this.useSts = false;
    }

    protected T produceClient() {
        T client;
        if (this.useSts) {
            InnerStsIdentity role;
            try {
                this.lastUpdateTime = System.currentTimeMillis();
                role = (InnerStsIdentity)cacheArnResponse.get((Object)"roleResponseKey");
            }
            catch (ExecutionException e) {
                logger.info("catched ExecutionException, maybe too much call", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (UncheckedExecutionException e) {
                logger.info("cached UncheckedExecutionException", (Throwable)e);
                throw new RuntimeException(e.getCause());
            }
            if (null == role) {
                throw new RuntimeException("failed to  get sts identify!");
            }
            client = this.produceStsClient(role.getAccessKeyId(), role.getAccessKeySecret(), role.getSecurityToken());
        } else {
            client = this.produceNormalClient(this.accessId, this.accessKey);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getClient(boolean forceReconnect, boolean forceRefresh) {
        long nowTime = System.currentTimeMillis();
        if (this.useSts) {
            if (forceRefresh || lastCertificationUpdateTime == 0L || nowTime - lastCertificationUpdateTime > (long)(stsExpireSeconds * 1000)) {
                logger.debug("refreshing sts token");
                Object object = MUTEX;
                synchronized (object) {
                    if (forceRefresh || lastCertificationUpdateTime == 0L || nowTime - lastCertificationUpdateTime > (long)(stsExpireSeconds * 1000)) {
                        lastCertificationUpdateTime = nowTime;
                        cacheArnResponse.invalidate((Object)"roleResponseKey");
                    }
                }
                logger.debug("reconnect client");
                this.closeClient();
                this.client = this.produceClient();
                return this.client;
            }
            if (forceReconnect || this.lastUpdateTime < lastCertificationUpdateTime || this.client == null) {
                logger.debug("reconnect client");
                this.closeClient();
                this.client = this.produceClient();
                return this.client;
            }
            return this.client;
        }
        if (forceRefresh || forceReconnect || this.client == null) {
            this.closeClient();
            this.client = this.produceClient();
            return this.client;
        }
        return this.client;
    }

    public T getClient(boolean forceReconnect) {
        return this.getClient(forceReconnect, false);
    }

    public T getClient() {
        return this.getClient(false, false);
    }

    public static int getStsExpireSeconds() {
        return stsExpireSeconds;
    }

    protected void setClientNull() {
        this.client = null;
    }

    protected abstract void closeClient();

    protected abstract T produceNormalClient(String var1, String var2);

    protected abstract T produceStsClient(String var1, String var2, String var3);

    public static class InnerStsIdentity {
        public String accessKeyId;
        public String accessKeySecret;
        public String securityToken;
        public int stsExpireSecond;
        public String roleArn;

        public InnerStsIdentity() {
        }

        public InnerStsIdentity(String accessKeyId, String accessKeySecret, String securityToken) {
            this(accessKeyId, accessKeySecret, securityToken, 86400);
        }

        public InnerStsIdentity(String accessKeyId, String accessKeySecret, String securityToken, int stsExpireSecond) {
            this.accessKeyId = accessKeyId;
            this.accessKeySecret = accessKeySecret;
            this.securityToken = securityToken;
            this.stsExpireSecond = stsExpireSecond;
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public InnerStsIdentity setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public String getAccessKeySecret() {
            return this.accessKeySecret;
        }

        public InnerStsIdentity setAccessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public String getSecurityToken() {
            return this.securityToken;
        }

        public InnerStsIdentity setSecurityToken(String securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        public int getStsExpireSecond() {
            return this.stsExpireSecond;
        }

        public String getRoleArn() {
            return this.roleArn;
        }

        public InnerStsIdentity setRoleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }
    }

    public static class DefaultStsCredentialProvider
    implements StsCredentialProvider {
        private String stsAccessId;
        private String stsAccessKey;
        private String stsRoleArn;
        private String stsSessionName;
        private String stsAssumeRoleFor;
        private Configuration properties;

        DefaultStsCredentialProvider(AbstractClientProvider<?> provider, Configuration properties) {
            this.stsAccessId = provider.stsAccessId;
            this.stsAccessKey = provider.stsAccessKey;
            this.stsRoleArn = provider.stsRoleArn;
            this.stsSessionName = provider.stsSessionName;
            this.stsAssumeRoleFor = provider.stsAssumeRoleFor;
            this.properties = new Configuration();
            this.properties.addAll(properties);
        }

        @Override
        public InnerStsIdentity getStsCredential() throws Exception {
            logger.info("getAssumeRole with para accessId " + this.stsAccessId + ", secretKey " + this.stsAccessKey + ", roleArn " + this.stsRoleArn + ", stsSessionName " + this.stsSessionName);
            AssumeRoleResponse role = StsServiceRequest.assumeRoleWithServiceIdentity(this.stsAccessId, this.stsAccessKey, this.stsRoleArn, this.stsSessionName, this.stsAssumeRoleFor, this.properties);
            return new InnerStsIdentity(role.getCredentials().getAccessKeyId(), role.getCredentials().getAccessKeySecret(), role.getCredentials().getSecurityToken());
        }
    }

    public static class StsIdentityLoader
    extends CacheLoader<String, InnerStsIdentity> {
        private StsCredentialProvider stsCredentialProvider;

        public StsIdentityLoader(StsCredentialProvider stsCredentialProvider) {
            this.stsCredentialProvider = stsCredentialProvider;
        }

        public InnerStsIdentity load(String key) throws Exception {
            InnerStsIdentity stsCredential = this.stsCredentialProvider.getStsCredential();
            stsExpireSeconds = stsCredential.getStsExpireSecond();
            logger.debug("loaded new sts credential id:{} expire in {} secs", (Object)stsCredential.accessKeyId, (Object)stsCredential.stsExpireSecond);
            return stsCredential;
        }
    }
}

