/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import com.alibaba.ververica.connectors.common.errorcode.ConnectorErrors;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.flink.util.Preconditions;

public class ByteUtils {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] toBytes(ByteBuffer buffer) {
        byte[] ret = new byte[buffer.remaining()];
        buffer.get(ret, 0, ret.length);
        return ret;
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static byte[] toBytes(byte val) {
        byte[] b = new byte[]{val};
        return b;
    }

    public static int toInt(byte[] bytes) {
        return ByteUtils.toInt(bytes, 0);
    }

    public static int toInt(byte[] bytes, int offset) {
        if (offset + 4 > bytes.length) {
            throw ByteUtils.explainWrongLengthOrOffset(bytes, offset, 4, 4);
        }
        int n = 0;
        for (int i = offset; i < offset + 4; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static byte[] toBytes(String s) {
        return s.getBytes(UTF8_CHARSET);
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        return ByteUtils.toString(b, 0, b.length);
    }

    public static String toString(byte[] b, int off) {
        if (b == null) {
            return null;
        }
        int len = b.length - off;
        if (len <= 0) {
            return "";
        }
        return new String(b, off, len, UTF8_CHARSET);
    }

    public static String toString(byte[] b, int off, int len) {
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        return new String(b, off, len, UTF8_CHARSET);
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static boolean toBoolean(byte[] b) {
        return ByteUtils.toBoolean(b, 0);
    }

    public static boolean toBoolean(byte[] b, int offset) {
        if (offset + 1 > b.length) {
            throw ByteUtils.explainWrongLengthOrOffset(b, offset, 1, 1);
        }
        return b[offset] != 0;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static long toLong(byte[] bytes) {
        return ByteUtils.toLong(bytes, 0);
    }

    public static long toLong(byte[] bytes, int offset) {
        if (offset + 8 > bytes.length) {
            throw ByteUtils.explainWrongLengthOrOffset(bytes, offset, 8, 8);
        }
        long l = 0L;
        for (int i = offset; i < offset + 8; ++i) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    public static byte[] toBytes(float f) {
        return ByteUtils.toBytes(Float.floatToRawIntBits(f));
    }

    public static float toFloat(byte[] bytes) {
        return ByteUtils.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(ByteUtils.toInt(bytes, offset));
    }

    public static byte[] toBytes(double d) {
        return ByteUtils.toBytes(Double.doubleToRawLongBits(d));
    }

    public static double toDouble(byte[] bytes) {
        return ByteUtils.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(ByteUtils.toLong(bytes, offset));
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (short)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static short toShort(byte[] bytes) {
        return ByteUtils.toShort(bytes, 0);
    }

    public static short toShort(byte[] bytes, int offset) {
        if (offset + 2 > bytes.length) {
            throw ByteUtils.explainWrongLengthOrOffset(bytes, offset, 2, 2);
        }
        short n = 0;
        n = (short)(n ^ bytes[offset] & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ bytes[offset + 1] & 0xFF);
        return n;
    }

    private static IllegalArgumentException explainWrongLengthOrOffset(byte[] bytes, int offset, int length, int expectedLength) {
        String reason = length != expectedLength ? "Wrong length: " + length + ", expected " + expectedLength : "offset (" + offset + ") + length (" + length + ") exceed the capacity of the array: " + bytes.length;
        return new IllegalArgumentException(ConnectorErrors.INST.byteUitlsConvertArgumentError(reason));
    }

    public static String toHexString(byte[] b, int offset, int length) {
        Preconditions.checkArgument((length <= 0x3FFFFFFF ? 1 : 0) != 0);
        int numChars = length * 2;
        char[] ch = new char[numChars];
        for (int i = 0; i < numChars; i += 2) {
            byte d = b[offset + i / 2];
            ch[i] = HEX_CHARS[d >> 4 & 0xF];
            ch[i + 1] = HEX_CHARS[d & 0xF];
        }
        return new String(ch);
    }

    public static String toHexString(byte[] b) {
        return ByteUtils.toHexString(b, 0, b.length);
    }

    public static byte[] fromHexString(String hex) {
        Preconditions.checkArgument((hex.length() % 2 == 0 ? 1 : 0) != 0, (Object)"length must be a multiple of 2");
        int len = hex.length();
        byte[] b = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            b[i / 2] = ByteUtils.hexCharsToByte(hex.charAt(i), hex.charAt(i + 1));
        }
        return b;
    }

    private static int hexCharToNibble(char ch) {
        if (ch <= '9' && ch >= '0') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex char: " + ch);
    }

    private static byte hexCharsToByte(char c1, char c2) {
        return (byte)(ByteUtils.hexCharToNibble(c1) << 4 | ByteUtils.hexCharToNibble(c2));
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return ByteUtils.toBigDecimal(bytes, 0, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        if (bytes != null && length >= 5 && offset + length <= bytes.length) {
            int scale = ByteUtils.toInt(bytes, offset);
            byte[] tcBytes = new byte[length - 4];
            System.arraycopy(bytes, offset + 4, tcBytes, 0, length - 4);
            return new BigDecimal(new BigInteger(tcBytes), scale);
        }
        return null;
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        int offset = ByteUtils.putInt(result, 0, val.scale());
        ByteUtils.putBytes(result, offset, valueBytes, 0, valueBytes.length);
        return result;
    }

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("Not enough room to put an int at offset " + offset + " in a " + bytes.length + " byte array");
        }
        for (int i = offset + 3; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 4;
    }
}

