/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.flink.api.java.tuple.Tuple2;

public class DateUtil {
    private static FastDateFormat dfTimeStamp = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss");
    private static ConcurrentHashMap<String, FastDateFormat> sdfCache = new ConcurrentHashMap();
    public static final long MILLIS_00_00;
    public static final long MILLIS_24_00;

    private static FastDateFormat getDateFormat(String timeZone, String format) {
        String key = String.valueOf(timeZone) + String.valueOf(format);
        if (null == timeZone || timeZone.isEmpty()) {
            return dfTimeStamp;
        }
        if (sdfCache.containsKey(key)) {
            return sdfCache.get(key);
        }
        FastDateFormat sdf = FastDateFormat.getInstance(format, TimeZone.getTimeZone(timeZone));
        sdfCache.put(key, sdf);
        return sdf;
    }

    public static String timeStamp2String(Timestamp value, String timeZone) {
        if (null == timeZone || timeZone.isEmpty()) {
            String res = dfTimeStamp.format(value);
            return res;
        }
        return DateUtil.timeStamp2String(value, timeZone, "yyyy-MM-dd HH:mm:ss");
    }

    public static String timeStamp2String(Timestamp value, String timeZone, @Nonnull String format) {
        FastDateFormat sdf = DateUtil.getDateFormat(timeZone, format);
        return sdf.format(value);
    }

    public static String date2String(Date value, String timeZone) {
        return DateUtil.date2String(value, timeZone, "yyyy-MM-dd");
    }

    public static String date2String(Date value, String timeZone, @Nonnull String format) {
        FastDateFormat sdf = DateUtil.getDateFormat(timeZone, format);
        return sdf.format(value);
    }

    public static Long parseDateString(String formatString, String dateString, String timeZone) throws ParseException {
        FastDateFormat simpleDateFormat = DateUtil.getDateFormat(timeZone, formatString);
        return simpleDateFormat.parse(dateString).getTime();
    }

    public static boolean isTimeInRange(List<Tuple2<Long, Long>> rangeList, long time) {
        Long timeInEpochDay = null;
        for (Tuple2<Long, Long> range : rangeList) {
            if ((Long)range.f0 <= MILLIS_24_00 && (Long)range.f1 <= MILLIS_24_00) {
                if (timeInEpochDay == null) {
                    timeInEpochDay = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()).withYear(1970).withMonth(1).withDayOfMonth(1).toInstant().toEpochMilli();
                }
                if ((Long)range.f0 > timeInEpochDay || timeInEpochDay > (Long)range.f1) continue;
                return true;
            }
            if ((Long)range.f0 > time || time > (Long)range.f1) continue;
            return true;
        }
        return false;
    }

    static {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
        try {
            MILLIS_00_00 = dateFormat.parse("00:00").getTime();
            MILLIS_24_00 = dateFormat.parse("24:00").getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Exceptions that should not occur when initializing MILLIS_00_00 and MILLIS_24_00");
        }
    }
}

