/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.factories.Factory;

public class FactoryOptionUtil {
    public static Map<String, String> normalizeOptionCaseAsFactory(Factory factory, Map<String, String> options) {
        Set originalKeySet = factory.requiredOptions().stream().map(ConfigOption::key).collect(Collectors.toSet());
        originalKeySet.addAll(factory.optionalOptions().stream().map(ConfigOption::key).collect(Collectors.toSet()));
        Map<String, String> requiredOptionKeysLowerCaseToOriginal = factory.requiredOptions().stream().collect(Collectors.toMap(option -> option.key().toLowerCase(), ConfigOption::key));
        Map<String, String> optionalOptionKeysLowerCaseToOriginal = factory.optionalOptions().stream().collect(Collectors.toMap(option -> option.key().toLowerCase(), ConfigOption::key));
        HashMap<String, String> asIsOptions = new HashMap<String, String>();
        HashMap<String, String> normalizedOptions = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String catalogOptionKey = entry.getKey();
            String catalogOptionValue = entry.getValue();
            if (originalKeySet.contains(catalogOptionKey)) {
                asIsOptions.put(catalogOptionKey, catalogOptionValue);
                continue;
            }
            normalizedOptions.put(requiredOptionKeysLowerCaseToOriginal.containsKey(catalogOptionKey.toLowerCase()) ? requiredOptionKeysLowerCaseToOriginal.get(catalogOptionKey.toLowerCase()) : optionalOptionKeysLowerCaseToOriginal.getOrDefault(catalogOptionKey.toLowerCase(), catalogOptionKey), catalogOptionValue);
        }
        HashMap<String, String> mergedOptions = new HashMap<String, String>(asIsOptions);
        mergedOptions.putAll(normalizedOptions);
        return mergedOptions;
    }
}

