/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import java.util.List;
import java.util.Optional;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.Constraint;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

public class TableSchemaUtils {
    public static TableSchema projectSchema(TableSchema tableSchema, int[][] projectedFields) {
        UniqueConstraint uniqueConstraint;
        Preconditions.checkArgument((boolean)org.apache.flink.table.utils.TableSchemaUtils.containsPhysicalColumnsOnly((TableSchema)tableSchema), (Object)"Projection is only supported for physical columns.");
        TableSchema.Builder builder = TableSchema.builder();
        FieldsDataType fields = (FieldsDataType)DataTypeUtils.projectRow((DataType)tableSchema.toRowDataType(), (int[][])projectedFields);
        RowType topFields = (RowType)fields.getLogicalType();
        List fieldNames = topFields.getFieldNames();
        for (int i = 0; i < topFields.getFieldCount(); ++i) {
            builder.field((String)fieldNames.get(i), (DataType)fields.getChildren().get(i));
        }
        Optional optionalUniqueConstraint = tableSchema.getPrimaryKey();
        if (optionalUniqueConstraint.isPresent() && (uniqueConstraint = (UniqueConstraint)optionalUniqueConstraint.get()).getType() == Constraint.ConstraintType.PRIMARY_KEY) {
            List pkColumns = uniqueConstraint.getColumns();
            boolean projectFieldsHasAllPk = true;
            for (String pkColumn : pkColumns) {
                if (fieldNames.contains(pkColumn)) continue;
                projectFieldsHasAllPk = false;
                break;
            }
            if (projectFieldsHasAllPk) {
                builder.primaryKey(pkColumns.toArray(new String[0]));
            }
        }
        return builder.build();
    }
}

