/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog;

import com.alibaba.ververica.connectors.kafka.catalog.KafkaConnectorType;
import com.alibaba.ververica.connectors.kafka.utils.KafkaSchemaUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.TopicDescription;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.TopicListing;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartitionInfo;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptions;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaCatalogBase
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaCatalogBase.class);
    public static final String DEFAULT_DB = "kafka";
    public static final String[] PK = new String[]{"partition", "offset"};
    protected static final Duration ADMIN_CLIENT_TIMEOUT = Duration.ofMinutes(1L);
    protected final Properties catalogProperties;
    protected final String bootstrapServers;
    protected final String groupId;
    protected final String keyPrefix;
    protected final String valuePrefix;
    protected final String format;
    protected AdminClient adminClient;

    public KafkaCatalogBase(String catalogName, String defaultDatabase, String bootstrapServers, String groupId, String format, String keyPrefix, String valuePrefix, Properties catalogProperties) {
        super(catalogName, defaultDatabase);
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)bootstrapServers) ? 1 : 0) != 0, (Object)"Bootstrap Servers can not be null or empty.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)groupId) ? 1 : 0) != 0, (Object)"Group id can not be null or empty.");
        Preconditions.checkState((boolean)this.checkKeyAndValuePrefix(valuePrefix, keyPrefix), (Object)"Key prefix and value prefix must not be the same or be the other's prefix.");
        this.bootstrapServers = bootstrapServers;
        this.groupId = groupId;
        this.catalogProperties = catalogProperties;
        this.format = format;
        this.keyPrefix = keyPrefix;
        this.valuePrefix = valuePrefix;
    }

    private boolean checkKeyAndValuePrefix(String valuePrefix, String keyPrefix) {
        if (StringUtils.isNullOrWhitespaceOnly((String)valuePrefix) || StringUtils.isNullOrWhitespaceOnly((String)keyPrefix)) {
            LOG.warn("Both keyPrefix and valuePrefix are empty string in this catalog {}.", (Object)this.getName());
            return true;
        }
        return !valuePrefix.startsWith(keyPrefix) && !keyPrefix.startsWith(valuePrefix);
    }

    public void open() throws CatalogException {
        this.adminClient = this.getKafkaAdminClient();
    }

    public void close() throws CatalogException {
        if (this.adminClient != null) {
            this.closeResource(this.adminClient);
        }
    }

    public List<String> listDatabases() throws CatalogException {
        return Collections.singletonList(this.getDefaultDatabase());
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"Database name can not be null or empty.");
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return new CatalogDatabaseImpl(new HashMap(), null);
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        return this.getDefaultDatabase().equals(databaseName);
    }

    public void createDatabase(String s, CatalogDatabase catalogDatabase, boolean b) throws DatabaseAlreadyExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropDatabase(String s, boolean b, boolean b1) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterDatabase(String s, CatalogDatabase catalogDatabase, boolean b) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listTables(String dbName) throws DatabaseNotExistException, CatalogException {
        if (!this.getDefaultDatabase().equals(dbName)) {
            throw new DatabaseNotExistException(this.getName(), dbName);
        }
        try {
            return this.adminClient.listTopics().listings().get(ADMIN_CLIENT_TIMEOUT.getSeconds(), TimeUnit.SECONDS).stream().filter(topicListing -> !topicListing.isInternal()).map(TopicListing::name).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new CatalogException("Fail to get topics from kafka admin client.", (Throwable)e);
        }
    }

    public List<String> listViews(String s) throws DatabaseNotExistException, CatalogException {
        return Collections.emptyList();
    }

    public boolean tableExists(ObjectPath objectPath) throws CatalogException {
        if (!this.getDefaultDatabase().equals(objectPath.getDatabaseName())) {
            return false;
        }
        try {
            return this.adminClient.listTopics().names().get(ADMIN_CLIENT_TIMEOUT.getSeconds(), TimeUnit.SECONDS).contains(objectPath.getObjectName());
        }
        catch (Exception e) {
            throw new CatalogException("Fail to get topics from kafka admin client.", (Throwable)e);
        }
    }

    public void dropTable(ObjectPath objectPath, boolean b) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void renameTable(ObjectPath objectPath, String s, boolean b) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void createTable(ObjectPath objectPath, CatalogBaseTable catalogBaseTable, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTable(ObjectPath objectPath, CatalogBaseTable catalogBaseTable, boolean b) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath objectPath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath objectPath, List<Expression> list) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogPartition getPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public boolean partitionExists(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void createPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogPartition catalogPartition, boolean b) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, boolean b) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogPartition catalogPartition, boolean b) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listFunctions(String s) throws DatabaseNotExistException, CatalogException {
        return Collections.emptyList();
    }

    public CatalogFunction getFunction(ObjectPath objectPath) throws FunctionNotExistException, CatalogException {
        throw new FunctionNotExistException("Not support to find functions.", objectPath);
    }

    public boolean functionExists(ObjectPath objectPath) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void createFunction(ObjectPath objectPath, CatalogFunction catalogFunction, boolean b) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterFunction(ObjectPath objectPath, CatalogFunction catalogFunction, boolean b) throws FunctionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropFunction(ObjectPath objectPath, boolean b) throws FunctionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath objectPath) throws TableNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath objectPath) throws TableNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public void alterTableStatistics(ObjectPath objectPath, CatalogTableStatistics catalogTableStatistics, boolean b) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTableColumnStatistics(ObjectPath objectPath, CatalogColumnStatistics catalogColumnStatistics, boolean b) throws TableNotExistException, CatalogException, TablePartitionedException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogTableStatistics catalogTableStatistics, boolean b) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionColumnStatistics(ObjectPath objectPath, CatalogPartitionSpec catalogPartitionSpec, CatalogColumnStatistics catalogColumnStatistics, boolean b) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    protected void closeResource(AutoCloseable resource) {
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private AdminClient getKafkaAdminClient() {
        Properties adminClientProps = new Properties();
        this.deepCopyProperties(this.catalogProperties, adminClientProps);
        adminClientProps.setProperty("bootstrap.servers", this.bootstrapServers);
        adminClientProps.setProperty("group.id", this.groupId);
        adminClientProps.setProperty("client.id", this.groupId + "-catalog-admin-client");
        return AdminClient.create(adminClientProps);
    }

    protected void deepCopyProperties(Properties from, Properties to) {
        for (String key : from.stringPropertyNames()) {
            to.setProperty(key, from.getProperty(key));
        }
    }

    protected Schema fromRowDataType(DataType dataType, String prefix) {
        Preconditions.checkNotNull((Object)dataType, (String)"Data type must not be null.");
        Preconditions.checkArgument((boolean)dataType.getLogicalType().is(LogicalTypeRoot.ROW), (Object)"Data type of ROW expected.");
        Schema.Builder builder = Schema.newBuilder();
        List fieldDataTypes = dataType.getChildren();
        List fieldNames = ((RowType)dataType.getLogicalType()).getFieldNames();
        IntStream.range(0, fieldDataTypes.size()).forEach(i -> builder.column(prefix + (String)fieldNames.get(i), (AbstractDataType)fieldDataTypes.get(i)));
        return builder.build();
    }

    @VisibleForTesting
    Schema appendKafkaMetadataAndPK(Schema schema, String[] primaryKeys) {
        Schema.Builder builder = Schema.newBuilder();
        builder.fromColumns(schema.getColumns());
        if (primaryKeys != null && primaryKeys.length > 0) {
            builder.primaryKey(primaryKeys);
        }
        for (Map.Entry<String, DataType> entry : KafkaSchemaUtils.KAFKA_METADATA.entrySet()) {
            builder.columnByMetadata(entry.getKey(), (AbstractDataType)entry.getValue(), true);
        }
        return builder.build();
    }

    protected List<TopicPartition> getTopicPartitions(String topic) {
        try {
            Map<String, TopicDescription> topicMetadata = this.adminClient.describeTopics(Collections.singletonList(topic)).all().get();
            List<TopicPartitionInfo> partitionsInfo = topicMetadata.get(topic).partitions();
            if (partitionsInfo != null) {
                return partitionsInfo.stream().map(topicPartitionInfo -> new TopicPartition(topic, topicPartitionInfo.partition())).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get topic partitions.", e);
        }
    }

    @VisibleForTesting
    Map<String, String> createTableProperties(String topic, Set<String> keyFieldNames, KafkaConnectorType kafkaConnectorType) {
        return this.createTableProperties(topic, keyFieldNames, kafkaConnectorType, false);
    }

    Map<String, String> createTableProperties(String topic, Set<String> keyFieldNames, KafkaConnectorType kafkaConnectorType, boolean treatKeyAsRaw) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(FactoryUtil.CONNECTOR.key(), kafkaConnectorType.getConnectorType());
        props.put(KafkaConnectorOptions.TOPIC.key(), topic);
        props.put(KafkaConnectorOptions.PROPS_BOOTSTRAP_SERVERS.key(), this.bootstrapServers);
        props.put(KafkaConnectorOptions.VALUE_FORMAT.key(), this.format);
        props.put(KafkaConnectorOptions.VALUE_FIELDS_PREFIX.key(), this.valuePrefix);
        if (!keyFieldNames.isEmpty()) {
            if (treatKeyAsRaw) {
                Preconditions.checkState((keyFieldNames.size() == 1 ? 1 : 0) != 0, (Object)"Error: The key format of this table is raw, but the number of keys is more than 1.");
            }
            props.put(KafkaConnectorOptions.KEY_FORMAT.key(), treatKeyAsRaw ? "raw" : this.format);
            props.put(KafkaConnectorOptions.KEY_FIELDS_PREFIX.key(), this.keyPrefix);
            props.put(KafkaConnectorOptions.VALUE_FIELDS_INCLUDE.key(), KafkaConnectorOptions.ValueFieldsStrategy.EXCEPT_KEY.name());
            if (KafkaConnectorType.KAFKA.equals((Object)kafkaConnectorType)) {
                props.put(KafkaConnectorOptions.KEY_FIELDS.key(), String.join((CharSequence)";", keyFieldNames));
            }
        }
        return props;
    }

    @VisibleForTesting
    public String getGroupId() {
        return this.groupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KafkaCatalogBase)) {
            return false;
        }
        KafkaCatalogBase that = (KafkaCatalogBase)((Object)o);
        return this.catalogProperties.equals(that.catalogProperties) && this.bootstrapServers.equals(that.bootstrapServers) && this.groupId.equals(that.groupId) && Objects.equals(this.keyPrefix, that.keyPrefix) && Objects.equals(this.valuePrefix, that.valuePrefix) && this.format.equals(that.format);
    }

    public int hashCode() {
        return Objects.hash(this.catalogProperties, this.bootstrapServers, this.groupId, this.keyPrefix, this.valuePrefix, this.format);
    }
}

