/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog.aliyun;

import com.alibaba.ververica.connectors.kafka.catalog.aliyun.AliyunKafkaClientParams;
import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.service.alikafka20190916.AsyncClient;
import com.aliyun.sdk.service.alikafka20190916.DefaultAsyncClientBuilder;
import com.aliyun.sdk.service.alikafka20190916.models.CreateTopicRequest;
import com.aliyun.sdk.service.alikafka20190916.models.CreateTopicResponse;
import com.aliyun.sdk.service.alikafka20190916.models.DeleteConsumerGroupRequest;
import com.aliyun.sdk.service.alikafka20190916.models.DeleteConsumerGroupResponse;
import com.aliyun.sdk.service.alikafka20190916.models.DeleteTopicRequest;
import com.aliyun.sdk.service.alikafka20190916.models.DeleteTopicResponse;
import com.aliyun.sdk.service.alikafka20190916.models.GetTopicListRequest;
import com.aliyun.sdk.service.alikafka20190916.models.GetTopicListResponse;
import com.aliyun.sdk.service.alikafka20190916.models.GetTopicListResponseBody;
import darabonba.core.client.ClientOverrideConfiguration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;

public class AliyunKafkaClient
implements AutoCloseable {
    private final AliyunKafkaClientParams params;
    private AsyncClient kafkaClient;

    public AliyunKafkaClient(AliyunKafkaClientParams params) {
        this.params = params;
    }

    public void open() {
        this.kafkaClient = this.initKafkaClient();
    }

    @Override
    public void close() throws Exception {
        if (this.kafkaClient != null) {
            this.kafkaClient.close();
        }
    }

    public void createTopic(String topic, boolean compactTopic, long timeout, TimeUnit unit) throws Exception {
        CreateTopicRequest createTopicRequest = CreateTopicRequest.builder().instanceId(this.params.getInstanceId()).topic(topic).remark("[C] " + this.params.getAccessKeyId()).regionId(this.params.getRegionId()).compactTopic(compactTopic).build();
        CompletableFuture<CreateTopicResponse> future = this.kafkaClient.createTopic(createTopicRequest);
        CreateTopicResponse response = future.get(timeout, unit);
        response.getBody();
    }

    public void deleteTopic(String topic, long timeout, TimeUnit unit) throws Exception {
        DeleteTopicRequest deleteTopicRequest = DeleteTopicRequest.builder().instanceId(this.params.getInstanceId()).topic(topic).regionId(this.params.getRegionId()).build();
        CompletableFuture<DeleteTopicResponse> future = this.kafkaClient.deleteTopic(deleteTopicRequest);
        future.get(timeout, unit);
    }

    public List<String> listTopic(long timeout, TimeUnit unit) throws Exception {
        GetTopicListRequest getTopicListRequest = GetTopicListRequest.builder().instanceId(this.params.getInstanceId()).build();
        CompletableFuture<GetTopicListResponse> future = this.kafkaClient.getTopicList(getTopicListRequest);
        GetTopicListResponse response = future.get(timeout, unit);
        return response.getBody().getTopicList().getTopicVO().stream().map(GetTopicListResponseBody.TopicVO::getTopic).collect(Collectors.toList());
    }

    public boolean deleteConsumerGroup(String groupId, long timeout, TimeUnit unit) throws Exception {
        DeleteConsumerGroupRequest deleteConsumerGroupRequest = DeleteConsumerGroupRequest.builder().instanceId(this.params.getInstanceId()).regionId(this.params.getRegionId()).consumerId(groupId).build();
        CompletableFuture<DeleteConsumerGroupResponse> future = this.kafkaClient.deleteConsumerGroup(deleteConsumerGroupRequest);
        DeleteConsumerGroupResponse response = future.get(timeout, unit);
        return response.getBody() != null && response.getBody().getSuccess() != false;
    }

    private AsyncClient initKafkaClient() {
        StaticCredentialProvider provider = StaticCredentialProvider.create(Credential.builder().accessKeyId(this.params.getAccessKeyId()).accessKeySecret(this.params.getAccessKeySecret()).build());
        return (AsyncClient)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)AsyncClient.builder().region(this.params.getRegionId())).credentialsProvider(provider)).overrideConfiguration(ClientOverrideConfiguration.create().setEndpointOverride(this.params.getEndpoint()))).build();
    }

    @VisibleForTesting
    public AliyunKafkaClientParams getParams() {
        return this.params;
    }
}

