/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog.aliyun;

import com.alibaba.ververica.connectors.kafka.catalog.factory.KafkaCatalogOptions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.Preconditions;

public class AliyunKafkaClientParams
implements Serializable {
    private static final List<ConfigOption<String>> REQUIRED_OPTIONS = Arrays.asList(KafkaCatalogOptions.ALIYUN_KAFKA_AK, KafkaCatalogOptions.ALIYUN_KAFKA_SK, KafkaCatalogOptions.ALIYUN_KAFKA_ENDPOINT, KafkaCatalogOptions.ALIYUN_KAFKA_REGION_ID, KafkaCatalogOptions.ALIYUN_KAFKA_INSTANCE_ID);
    private static final String ERROR_MSG = "%s option is required, but it is not configured yet.";
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String endpoint;
    private final String regionId;
    private final String instanceId;

    public AliyunKafkaClientParams(String accessKeyId, String accessKeySecret, String endpoint, String regionId, String instanceId) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.endpoint = endpoint;
        this.regionId = regionId;
        this.instanceId = instanceId;
    }

    @Nullable
    public static AliyunKafkaClientParams createAliyunKafkaClientParams(ReadableConfig catalogOptions) {
        String instanceId = catalogOptions.getOptional(KafkaCatalogOptions.ALIYUN_KAFKA_INSTANCE_ID).orElse(null);
        if (instanceId == null) {
            for (ConfigOption<String> option : REQUIRED_OPTIONS) {
                if (catalogOptions.getOptional(option).orElse(null) == null) continue;
                throw new IllegalArgumentException(String.format("%s option is not supported for current Kafka Cluster, it only works for Aliyun Kafka Cluster.", option.key()));
            }
            return null;
        }
        return new AliyunKafkaClientParams((String)Preconditions.checkNotNull((Object)catalogOptions.getOptional(KafkaCatalogOptions.ALIYUN_KAFKA_AK).orElse(null), (String)String.format(ERROR_MSG, KafkaCatalogOptions.ALIYUN_KAFKA_AK.key())), (String)Preconditions.checkNotNull((Object)catalogOptions.getOptional(KafkaCatalogOptions.ALIYUN_KAFKA_SK).orElse(null), (String)String.format(ERROR_MSG, KafkaCatalogOptions.ALIYUN_KAFKA_SK.key())), (String)Preconditions.checkNotNull((Object)catalogOptions.getOptional(KafkaCatalogOptions.ALIYUN_KAFKA_ENDPOINT).orElse(null), (String)String.format(ERROR_MSG, KafkaCatalogOptions.ALIYUN_KAFKA_ENDPOINT.key())), (String)Preconditions.checkNotNull((Object)catalogOptions.getOptional(KafkaCatalogOptions.ALIYUN_KAFKA_REGION_ID).orElse(null), (String)String.format(ERROR_MSG, KafkaCatalogOptions.ALIYUN_KAFKA_REGION_ID.key())), instanceId);
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AliyunKafkaClientParams)) {
            return false;
        }
        AliyunKafkaClientParams that = (AliyunKafkaClientParams)o;
        return this.accessKeyId.equals(that.accessKeyId) && this.accessKeySecret.equals(that.accessKeySecret) && this.endpoint.equals(that.endpoint) && this.regionId.equals(that.regionId) && this.instanceId.equals(that.instanceId);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyId, this.accessKeySecret, this.endpoint, this.regionId, this.instanceId);
    }
}

