/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog.factory;

import java.util.Map;
import java.util.Properties;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.streaming.connectors.kafka.table.KafkaConnectorOptions;

public class KafkaCatalogOptions {
    public static final String IDENTIFIER = "kafka";
    public static final String DEFAULT_DATABASE_NAME = "kafka";
    public static final String DEFAULT_PARSE_KEY_ERROR_FIELD_NAME = "col";
    public static final String DEFAULT_GROUP_ID = "catalogReader";
    public static final Integer DEFAULT_SCHEMA_CAPACITY = 1000;
    public static final String DEFAULT_KEY_PREFIX = "key_";
    public static final String DEFAULT_VALUE_PREFIX = "value_";
    public static final String TABLE_PLACEHOLDER = "{table-name}";
    public static final ConfigOption<String> DEFAULT_DATABASE = ConfigOptions.key((String)"default-database").stringType().defaultValue((Object)"kafka").withDescription("Default database name, the default value is kafka.");
    public static final ConfigOption<String> PARSE_KEY_ERROR_FIELD_NAME = ConfigOptions.key((String)"infer-schema.parse-key-error.field-name").stringType().defaultValue((Object)"col").withDescription("Default field name for kafka key if fail to parse kafka key, the default value is 'col'.");
    public static final ConfigOption<Integer> MAX_FETCH_RECORDS = ConfigOptions.key((String)"max.fetch.records").intType().defaultValue((Object)10).withDescription("The max number of records to be parsed by the catalog.");
    public static final ConfigOption<Integer> SCHEMA_CAPACITY = ConfigOptions.key((String)"schema-capacity").intType().defaultValue((Object)DEFAULT_SCHEMA_CAPACITY);
    public static final ConfigOption<Boolean> COMPACTED_TOPIC_AS_UPSERT_TABLE = ConfigOptions.key((String)"infer-schema.compacted-topic-as-upsert-table").booleanType().defaultValue((Object)true).withDescription("Whether treat the compacted topic with non-empty key fields as an upsert kafka table.");
    public static final ConfigOption<String> ALIYUN_KAFKA_AK = ConfigOptions.key((String)"aliyun.kafka.accessKeyId").stringType().noDefaultValue().withDescription("User AccessKey ID.");
    public static final ConfigOption<String> ALIYUN_KAFKA_SK = ConfigOptions.key((String)"aliyun.kafka.accessKeySecret").stringType().noDefaultValue().withDescription("User AccessKey Secret.");
    public static final ConfigOption<String> ALIYUN_KAFKA_INSTANCE_ID = ConfigOptions.key((String)"aliyun.kafka.instanceId").stringType().noDefaultValue().withDescription("The instance id of the aliyun kafka.");
    public static final ConfigOption<String> ALIYUN_KAFKA_ENDPOINT = ConfigOptions.key((String)"aliyun.kafka.endpoint").stringType().noDefaultValue().withDescription("The endpoint of the aliyun kafka.");
    public static final ConfigOption<String> ALIYUN_KAFKA_REGION_ID = ConfigOptions.key((String)"aliyun.kafka.regionId").stringType().noDefaultValue().withDescription("The region id of the aliyun kafka.");
    public static final ConfigOption<String> CDAS_TOPIC_PATTERN = ConfigOptions.key((String)"cdas.topic.pattern").stringType().noDefaultValue().withDescription("Define the topic pattern when creating topics in the CDAS sql.User should use {table-name} as the placeholder for the table name. For example, when using the topic pattern 'mydbPrefix-{table-name}', the table 'sourceTable' will correspond to the topic 'mydbPrefix-sourceTable' in Kafka.");

    public static Properties getOtherProperties(Map<String, String> catalogOptions, String prefix) {
        Properties properties = new Properties();
        if (KafkaCatalogOptions.hasOtherProperties(catalogOptions, prefix)) {
            catalogOptions.keySet().stream().filter(key -> !KafkaConnectorOptions.PROPS_BOOTSTRAP_SERVERS.key().equals(key) && key.startsWith(prefix)).forEach(key -> {
                String value = (String)catalogOptions.get(key);
                String subKey = key.substring(prefix.length());
                properties.put(subKey, value);
            });
        }
        return properties;
    }

    private static boolean hasOtherProperties(Map<String, String> catalogOptions, String prefix) {
        return catalogOptions.keySet().stream().anyMatch(k -> k.startsWith(prefix));
    }
}

