/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry;

import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.SchemaProvider;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.SchemaVersionFetcher;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSchemaProvider
implements SchemaProvider {
    private SchemaVersionFetcher schemaVersionFetcher;

    @Override
    public void configure(Map<String, ?> configs) {
        this.schemaVersionFetcher = (SchemaVersionFetcher)configs.get("schemaVersionFetcher");
    }

    public SchemaVersionFetcher schemaVersionFetcher() {
        return this.schemaVersionFetcher;
    }

    protected Map<String, String> resolveReferences(Schema schema) {
        List<SchemaReference> references = schema.getReferences();
        if (references == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        HashSet<String> visited = new HashSet<String>();
        this.resolveReferences(schema, result, visited);
        return result;
    }

    private void resolveReferences(Schema schema, Map<String, String> schemas, Set<String> visited) {
        List<SchemaReference> references = schema.getReferences();
        for (SchemaReference reference : references) {
            if (reference.getName() == null || reference.getSubject() == null || reference.getVersion() == null) {
                throw new IllegalStateException("Invalid reference: " + reference);
            }
            if (visited.contains(reference.getName())) continue;
            visited.add(reference.getName());
            if (schemas.containsKey(reference.getName())) continue;
            QualifiedSubject refSubject = QualifiedSubject.qualifySubjectWithParent(this.schemaVersionFetcher().tenant(), schema.getSubject(), reference.getSubject());
            Schema s = this.schemaVersionFetcher().getByVersion(refSubject.toQualifiedSubject(), reference.getVersion(), true);
            if (s == null) {
                throw new IllegalStateException("No schema reference found for subject \"" + refSubject + "\" and version " + reference.getVersion());
            }
            if (reference.getVersion() == -1) {
                reference.setVersion(s.getVersion());
            }
            this.resolveReferences(s, schemas, visited);
            schemas.put(reference.getName(), s.getSchema());
        }
    }
}

