/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities;

import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Config")
public class Config {
    private String alias;
    private Boolean normalize;
    private Boolean validateFields;
    private String compatibilityLevel;
    private String compatibilityGroup;
    private Metadata defaultMetadata;
    private Metadata overrideMetadata;
    private RuleSet defaultRuleSet;
    private RuleSet overrideRuleSet;

    @JsonCreator
    public Config(@JsonProperty(value="alias") String alias, @JsonProperty(value="normalize") Boolean normalize, @JsonProperty(value="validateFields") Boolean validateFields, @JsonProperty(value="compatibilityLevel") String compatibilityLevel, @JsonProperty(value="compatibilityGroup") String compatibilityGroup, @JsonProperty(value="defaultMetadata") Metadata defaultMetadata, @JsonProperty(value="overrideMetadata") Metadata overrideMetadata, @JsonProperty(value="defaultRuleSet") RuleSet defaultRuleSet, @JsonProperty(value="overrideRuleSet") RuleSet overrideRuleSet) {
        this.alias = alias;
        this.normalize = normalize;
        this.validateFields = validateFields;
        this.compatibilityLevel = compatibilityLevel;
        this.compatibilityGroup = compatibilityGroup;
        this.defaultMetadata = defaultMetadata;
        this.overrideMetadata = overrideMetadata;
        this.defaultRuleSet = defaultRuleSet;
        this.overrideRuleSet = overrideRuleSet;
    }

    public Config(@JsonProperty(value="compatibilityLevel") String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    public Config() {
    }

    public Config(ConfigUpdateRequest request) {
        this.alias = request.getAlias();
        this.normalize = request.isNormalize();
        this.validateFields = request.isValidateFields();
        this.compatibilityLevel = request.getCompatibilityLevel();
        this.compatibilityGroup = request.getCompatibilityGroup();
        this.defaultMetadata = request.getDefaultMetadata();
        this.overrideMetadata = request.getOverrideMetadata();
        this.defaultRuleSet = request.getDefaultRuleSet();
        this.overrideRuleSet = request.getOverrideRuleSet();
    }

    @JsonProperty(value="alias")
    public String getAlias() {
        return this.alias;
    }

    @JsonProperty(value="alias")
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @JsonProperty(value="normalize")
    public Boolean isNormalize() {
        return this.normalize;
    }

    @JsonProperty(value="normalize")
    public void setNormalize(Boolean normalize) {
        this.normalize = normalize;
    }

    @JsonProperty(value="validateFields")
    public Boolean isValidateFields() {
        return this.validateFields;
    }

    @JsonProperty(value="validateFields")
    public void setValidateFields(Boolean validateFieldNames) {
        this.validateFields = validateFieldNames;
    }

    @Schema(description="Compatibility Level", allowableValues={"BACKWARD", "BACKWARD_TRANSITIVE", "FORWARD", "FORWARD_TRANSITIVE", "FULL", "FULL_TRANSITIVE", "NONE"}, example="FULL_TRANSITIVE")
    @JsonProperty(value="compatibilityLevel")
    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    @JsonProperty(value="compatibilityLevel")
    public void setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    @JsonProperty(value="compatibilityGroup")
    public String getCompatibilityGroup() {
        return this.compatibilityGroup;
    }

    @JsonProperty(value="compatibilityGroup")
    public void setCompatibilityGroup(String compatibilityGroup) {
        this.compatibilityGroup = compatibilityGroup;
    }

    @JsonProperty(value="defaultMetadata")
    public Metadata getDefaultMetadata() {
        return this.defaultMetadata;
    }

    @JsonProperty(value="defaultMetadata")
    public void setDefaultMetadata(Metadata defaultMetadata) {
        this.defaultMetadata = defaultMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public Metadata getOverrideMetadata() {
        return this.overrideMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public void setOverrideMetadata(Metadata overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    @JsonProperty(value="defaultRuleSet")
    public RuleSet getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    @JsonProperty(value="defaultRuleSet")
    public void setDefaultRuleSet(RuleSet defaultRuleSet) {
        this.defaultRuleSet = defaultRuleSet;
    }

    @JsonProperty(value="overrideRuleSet")
    public RuleSet getOverrideRuleSet() {
        return this.overrideRuleSet;
    }

    @JsonProperty(value="overrideRuleSet")
    public void setOverrideRuleSet(RuleSet overrideRuleSet) {
        this.overrideRuleSet = overrideRuleSet;
    }

    @JsonIgnore
    public boolean hasDefaultsOrOverrides() {
        return this.defaultMetadata != null || this.overrideMetadata != null || this.defaultRuleSet != null || this.overrideRuleSet != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return Objects.equals(this.alias, config.alias) && Objects.equals(this.normalize, config.normalize) && Objects.equals(this.validateFields, config.validateFields) && Objects.equals(this.compatibilityLevel, config.compatibilityLevel) && Objects.equals(this.compatibilityGroup, config.compatibilityGroup) && Objects.equals(this.defaultMetadata, config.defaultMetadata) && Objects.equals(this.overrideMetadata, config.overrideMetadata) && Objects.equals(this.defaultRuleSet, config.defaultRuleSet) && Objects.equals(this.overrideRuleSet, config.overrideRuleSet);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.normalize, this.validateFields, this.compatibilityLevel, this.compatibilityGroup, this.defaultMetadata, this.overrideMetadata, this.defaultRuleSet, this.overrideRuleSet);
    }

    public String toString() {
        return "Config{alias='" + this.alias + '\'' + ", normalize=" + this.normalize + ", validateFields=" + this.validateFields + ", compatibilityLevel='" + this.compatibilityLevel + '\'' + ", compatibilityGroup='" + this.compatibilityGroup + '\'' + ", defaultMetadata=" + this.defaultMetadata + ", overrideMetadata=" + this.overrideMetadata + ", defaultRuleSet=" + this.defaultRuleSet + ", overrideRuleSet=" + this.overrideRuleSet + '}';
    }
}

