/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities;

import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTypeConverter;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@io.swagger.v3.oas.annotations.media.Schema(description="Schema definition")
public class SchemaString {
    private String schemaType = "AVRO";
    private String schemaString;
    private List<SchemaReference> references = Collections.emptyList();
    private Metadata metadata = null;
    private RuleSet ruleSet = null;
    private Integer maxId;

    public SchemaString() {
    }

    public SchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    public SchemaString(Schema schema) {
        this.schemaType = schema.getSchemaType();
        this.schemaString = schema.getSchema();
        this.references = schema.getReferences();
        this.metadata = schema.getMetadata();
        this.ruleSet = schema.getRuleSet();
    }

    public static SchemaString fromJson(String json) throws IOException {
        return (SchemaString)JacksonMapper.INSTANCE.readValue(json, SchemaString.class);
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema type", example="AVRO")
    @JsonProperty(value="schemaType")
    @JsonSerialize(converter=SchemaTypeConverter.class)
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema string identified by the ID", example="{\"schema\": \"{\"type\": \"string\"}\"}")
    @JsonProperty(value="schema")
    public String getSchemaString() {
        return this.schemaString;
    }

    @JsonProperty(value="schema")
    public void setSchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="References to other schemas")
    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="User-defined metadata")
    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema rule set")
    @JsonProperty(value="ruleSet")
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    @JsonProperty(value="ruleSet")
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Maximum ID", example="1")
    @JsonProperty(value="maxId")
    public Integer getMaxId() {
        return this.maxId;
    }

    @JsonProperty(value="maxId")
    public void setMaxId(Integer maxId) {
        this.maxId = maxId;
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaString that = (SchemaString)o;
        return Objects.equals(this.schemaType, that.schemaType) && Objects.equals(this.schemaString, that.schemaString) && Objects.equals(this.references, that.references) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet) && Objects.equals(this.maxId, that.maxId);
    }

    public int hashCode() {
        return Objects.hash(this.schemaType, this.schemaString, this.references, this.metadata, this.ruleSet, this.maxId);
    }
}

