/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ServerClusterId {
    private static final String KAFKA_CLUSTER = "kafka-cluster";
    private static final String SCHEMA_REGISTRY_CLUSTER = "schema-registry-cluster";
    private final String id = "";
    private final Map<String, Object> scope;

    @JsonCreator
    public ServerClusterId(@JsonProperty(value="scope") Map<String, Object> scope) {
        this.scope = Collections.unmodifiableMap(Objects.requireNonNull(scope, "scope"));
    }

    public String getId() {
        return "";
    }

    public Map<String, Object> getScope() {
        return this.scope;
    }

    public static ServerClusterId of(String kafkaClusterId, String schemaRegistryClusterId) {
        HashMap<String, String> clusters = new HashMap<String, String>();
        clusters.put(KAFKA_CLUSTER, kafkaClusterId);
        clusters.put(SCHEMA_REGISTRY_CLUSTER, schemaRegistryClusterId);
        HashMap<String, Object> serverClusterId = new HashMap<String, Object>();
        serverClusterId.put("path", Collections.emptyList());
        serverClusterId.put("clusters", Collections.unmodifiableMap(clusters));
        return new ServerClusterId(Collections.unmodifiableMap(serverClusterId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerClusterId)) {
            return false;
        }
        ServerClusterId that = (ServerClusterId)o;
        return this.getId().equals(that.getId()) && this.getScope().equals(that.getScope());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getScope());
    }
}

