/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth;

import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.OauthTokenCache;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.exceptions.SchemaRegistryOauthTokenRetrieverException;
import java.io.IOException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;

class CachedOauthTokenRetriever {
    private AccessTokenRetriever accessTokenRetriever;
    private AccessTokenValidator accessTokenValidator;
    private OauthTokenCache oauthTokenCache;

    CachedOauthTokenRetriever() {
    }

    public void configure(AccessTokenRetriever accessTokenRetriever, AccessTokenValidator accessTokenValidator, OauthTokenCache oauthTokenCache) {
        this.accessTokenRetriever = accessTokenRetriever;
        this.accessTokenValidator = accessTokenValidator;
        this.oauthTokenCache = oauthTokenCache;
    }

    public String getToken() {
        if (this.oauthTokenCache.isTokenExpired()) {
            OAuthBearerToken oauthBearerToken;
            String token = null;
            try {
                token = this.accessTokenRetriever.retrieve();
            }
            catch (IOException | RuntimeException e) {
                throw new SchemaRegistryOauthTokenRetrieverException("Failed to Retrieve OAuth Token for Schema Registry", e);
            }
            try {
                oauthBearerToken = this.accessTokenValidator.validate(token);
            }
            catch (ValidateException e) {
                throw new SchemaRegistryOauthTokenRetrieverException("OAuth Token for Schema Registry is Invalid", e);
            }
            this.oauthTokenCache.setCurrentToken(oauthBearerToken);
        }
        return this.oauthTokenCache.getCurrentToken().value();
    }
}

