/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.rules;

import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.ParsedSchema;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.utils.WildcardMatcher;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.header.Headers;

public class RuleContext {
    private final Map<String, ?> configs;
    private final ParsedSchema source;
    private final ParsedSchema target;
    private final String subject;
    private final String topic;
    private final Headers headers;
    private final Object originalKey;
    private final Object originalValue;
    private final boolean isKey;
    private final RuleMode ruleMode;
    private final Rule rule;
    private final int index;
    private final List<Rule> rules;
    private final Map<Object, Object> customData = new ConcurrentHashMap<Object, Object>();
    private final Deque<FieldContext> fieldContexts;

    public RuleContext(Map<String, ?> configs, ParsedSchema source, ParsedSchema target, String subject, String topic, Headers headers, Object originalKey, Object originalValue, boolean isKey, RuleMode ruleMode, Rule rule, int index, List<Rule> rules) {
        this.configs = configs;
        this.source = source;
        this.target = target;
        this.subject = subject;
        this.topic = topic;
        this.headers = headers;
        this.originalKey = originalKey;
        this.originalValue = originalValue;
        this.isKey = isKey;
        this.ruleMode = ruleMode;
        this.rule = rule;
        this.index = index;
        this.rules = rules;
        this.fieldContexts = new ArrayDeque<FieldContext>();
    }

    public Map<String, ?> configs() {
        return this.configs;
    }

    public ParsedSchema source() {
        return this.source;
    }

    public ParsedSchema target() {
        return this.target;
    }

    public String subject() {
        return this.subject;
    }

    public String topic() {
        return this.topic;
    }

    public Headers headers() {
        return this.headers;
    }

    public Object originalKey() {
        return this.originalKey;
    }

    public Object originalValue() {
        return this.originalValue;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public RuleMode ruleMode() {
        return this.ruleMode;
    }

    public Rule rule() {
        return this.rule;
    }

    public int index() {
        return this.index;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public Map<Object, Object> customData() {
        return this.customData;
    }

    public Set<String> getTags(String fullName) {
        HashSet<String> tags = new HashSet<String>();
        Metadata metadata = this.target.metadata();
        if (metadata != null && metadata.getTags() != null) {
            for (Map.Entry<String, SortedSet<String>> entry : metadata.getTags().entrySet()) {
                if (!WildcardMatcher.match(fullName, entry.getKey())) continue;
                tags.addAll((Collection<String>)entry.getValue());
            }
        }
        return tags;
    }

    public String getParameter(String name) {
        SortedMap<String, String> properties;
        Metadata metadata;
        String value = null;
        SortedMap<String, String> params = this.rule.getParams();
        if (params != null) {
            value = (String)params.get(name);
        }
        if (value == null && (metadata = this.target.metadata()) != null && (properties = metadata.getProperties()) != null) {
            value = (String)properties.get(name);
        }
        return value;
    }

    public FieldContext currentField() {
        return this.fieldContexts.peekLast();
    }

    public FieldContext enterField(RuleContext ctx, Object containingMessage, String fullName, String name, Type type, Set<String> tags) {
        HashSet<String> allTags = new HashSet<String>(tags);
        allTags.addAll(ctx.getTags(fullName));
        return new FieldContext(containingMessage, fullName, name, type, allTags);
    }

    public static enum Type {
        RECORD(false),
        ENUM(false),
        ARRAY(false),
        MAP(false),
        COMBINED(false),
        FIXED(false),
        STRING(true),
        BYTES(true),
        INT(true),
        LONG(true),
        FLOAT(true),
        DOUBLE(true),
        BOOLEAN(true),
        NULL(true);

        private boolean isPrimitive;

        private Type(boolean isPrimitive) {
            this.isPrimitive = isPrimitive;
        }

        public boolean isPrimitive() {
            return this.isPrimitive;
        }
    }

    public class FieldContext
    implements AutoCloseable {
        private final Object containingMessage;
        private final String fullName;
        private final String name;
        private Type type;
        private final Set<String> tags;

        public FieldContext(Object containingMessage, String fullName, String name, Type type, Set<String> tags) {
            this.containingMessage = containingMessage;
            this.fullName = fullName;
            this.name = name;
            this.type = type;
            this.tags = tags;
            RuleContext.this.fieldContexts.addLast(this);
        }

        public Object getContainingMessage() {
            return this.containingMessage;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldContext that = (FieldContext)o;
            return Objects.equals(this.containingMessage, that.containingMessage) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.name, that.name) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.tags, that.tags);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.containingMessage, this.fullName, this.name, this.type, this.tags});
        }

        @Override
        public void close() {
            RuleContext.this.fieldContexts.removeLast();
        }
    }
}

