/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.catalog.shaded.io.confluent.kafka.schemaregistry.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.ConfigDef;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.ConfigException;

public class EnumRecommender
implements ConfigDef.Validator,
ConfigDef.Recommender {
    private final List<String> canonicalValues;
    private final Set<String> validValues;

    private EnumRecommender(List<String> canonicalValues, Set<String> validValues) {
        this.canonicalValues = canonicalValues;
        this.validValues = validValues;
    }

    @SafeVarargs
    public static <E> EnumRecommender in(E ... enumerators) {
        ArrayList<String> canonicalValues = new ArrayList<String>(enumerators.length);
        HashSet<String> validValues = new HashSet<String>(enumerators.length * 2);
        for (E e : enumerators) {
            canonicalValues.add(e.toString().toLowerCase(Locale.ROOT));
            validValues.add(e.toString().toLowerCase(Locale.ROOT));
            validValues.add(e.toString().toUpperCase(Locale.ROOT));
        }
        return new EnumRecommender(canonicalValues, validValues);
    }

    @Override
    public void ensureValid(String key, Object value) {
        if (value != null && !this.validValues.contains(value.toString())) {
            throw new ConfigException(key, value, "Invalid enumerator");
        }
    }

    public String toString() {
        return this.canonicalValues.toString();
    }

    @Override
    public List<Object> validValues(String name, Map<String, Object> configs) {
        return new ArrayList<Object>(this.canonicalValues);
    }

    @Override
    public boolean visible(String name, Map<String, Object> configs) {
        return true;
    }
}

