/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.kafka.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.AnsiLogicalTypeMerging;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;
import org.apache.flink.util.Preconditions;

public class KafkaSchemaUtils {
    public static final LinkedHashMap<String, DataType> KAFKA_METADATA = new LinkedHashMap();

    public static Schema mergeSchema(Schema schema1, Schema schema2) {
        Map<String, DataType> columns1 = KafkaSchemaUtils.getPhysicalColumns(schema1);
        Map<String, DataType> columns2 = KafkaSchemaUtils.getPhysicalColumns(schema2);
        List<String> columnNames1 = KafkaSchemaUtils.getPhysicalColumnNames(schema1);
        List<String> columnNames2 = KafkaSchemaUtils.getPhysicalColumnNames(schema2);
        Schema.Builder builder = Schema.newBuilder();
        for (String columnName : columnNames1) {
            if (columns2.containsKey(columnName)) {
                builder.column(columnName, (AbstractDataType)KafkaSchemaUtils.findCommonDataType(columns1.get(columnName), columns2.get(columnName)));
                continue;
            }
            builder.column(columnName, (AbstractDataType)columns1.get(columnName));
        }
        for (String columnName : columnNames2) {
            if (columns1.containsKey(columnName)) continue;
            builder.column(columnName, (AbstractDataType)columns2.get(columnName));
        }
        builder.fromColumns(schema1.getColumns().stream().filter(c -> !(c instanceof Schema.UnresolvedPhysicalColumn)).collect(Collectors.toList()));
        return builder.build();
    }

    public static Map<String, DataType> getPhysicalColumns(Schema schema) {
        return schema.getColumns().stream().filter(c -> c instanceof Schema.UnresolvedPhysicalColumn).map(c -> (Schema.UnresolvedPhysicalColumn)c).collect(Collectors.toMap(Schema.UnresolvedColumn::getName, c -> (DataType)c.getDataType()));
    }

    public static List<String> getPhysicalColumnNames(Schema schema) {
        return schema.getColumns().stream().filter(c -> c instanceof Schema.UnresolvedPhysicalColumn).map(Schema.UnresolvedColumn::getName).collect(Collectors.toList());
    }

    private static DataType findCommonDataType(DataType ... types) {
        Preconditions.checkArgument((types.length > 0 ? 1 : 0) != 0, (Object)"List of types must not be empty.");
        Optional commonLogicalType = AnsiLogicalTypeMerging.findCommonType(Arrays.stream(types).map(DataType::getLogicalType).collect(Collectors.toList()));
        if (commonLogicalType.isPresent()) {
            return LogicalTypeDataTypeConverter.toDataType((LogicalType)((LogicalType)commonLogicalType.get()));
        }
        throw new IllegalStateException("There must be a common data type to be found, some bug occurs.");
    }

    public static void checkFieldConflict(Schema schema) {
        HashSet<String> columnNames = new HashSet<String>();
        for (Schema.UnresolvedColumn col : schema.getColumns()) {
            String colName = col.getName();
            Preconditions.checkState((!columnNames.contains(colName) ? 1 : 0) != 0, (Object)String.format("There are duplicated field name %s from key fields and value fields, please configure key.fields-prefix and value.fields-prefix to avoid the field name conflict.", colName));
            columnNames.add(colName);
        }
    }

    public static Schema generateKafkaSchemaForCatalog(Schema mergedSchema, Set<String> keyFieldNames, String[] primaryKeys) {
        AbstractDataType dataType;
        Map<String, Schema.UnresolvedColumn> nameToColumn = mergedSchema.getColumns().stream().collect(Collectors.toMap(Schema.UnresolvedColumn::getName, col -> col));
        ArrayList<Object> sortKeyFieldNames = new ArrayList();
        if (!keyFieldNames.isEmpty()) {
            sortKeyFieldNames = new ArrayList<String>(keyFieldNames);
            sortKeyFieldNames.sort(String::compareTo);
        }
        HashSet<Object> pkSet = new HashSet();
        if (primaryKeys != null && primaryKeys.length > 0) {
            pkSet = new HashSet<String>(Arrays.asList(primaryKeys));
        }
        List sortValueFieldNames = mergedSchema.getColumns().stream().map(Schema.UnresolvedColumn::getName).filter(colName -> !keyFieldNames.contains(colName)).sorted(String::compareTo).collect(Collectors.toList());
        Schema.Builder builder = Schema.newBuilder();
        for (String string : sortKeyFieldNames) {
            dataType = ((Schema.UnresolvedPhysicalColumn)nameToColumn.get(string)).getDataType();
            builder.column(string, pkSet.contains(string) ? dataType.notNull() : dataType);
        }
        for (String string : sortValueFieldNames) {
            dataType = ((Schema.UnresolvedPhysicalColumn)nameToColumn.get(string)).getDataType();
            builder.column(string, pkSet.contains(string) ? dataType.notNull() : dataType);
        }
        return KafkaSchemaUtils.appendKafkaMetadataAndPK(builder.build(), primaryKeys);
    }

    private static Schema appendKafkaMetadataAndPK(Schema schema, String[] primaryKeys) {
        Schema.Builder builder = Schema.newBuilder();
        builder.fromColumns(schema.getColumns());
        if (primaryKeys != null && primaryKeys.length > 0) {
            builder.primaryKey(primaryKeys);
        }
        for (Map.Entry<String, DataType> entry : KAFKA_METADATA.entrySet()) {
            builder.columnByMetadata(entry.getKey(), (AbstractDataType)entry.getValue(), true);
        }
        return builder.build();
    }

    static {
        KAFKA_METADATA.put("partition", (DataType)DataTypes.INT().notNull());
        KAFKA_METADATA.put("offset", (DataType)DataTypes.BIGINT().notNull());
        KAFKA_METADATA.put("timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull());
    }
}

