/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.sts.fetcher;

import com.alibaba.ververica.sts.fetcher.config.StsFetcherConfigOptions;
import com.alibaba.ververica.sts.fetcher.entity.StsCredential;
import com.alibaba.ververica.sts.fetcher.retriever.StsCredentialFileRetriever;
import com.alibaba.ververica.sts.fetcher.retriever.StsCredentialHttpRetriever;
import com.alibaba.ververica.sts.fetcher.retriever.StsCredentialRetriever;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class StsFetcher {
    public static StsCredential getStsCredentialViaEnv(Map<String, String> envs) {
        String alicloudStsCredentialProvider = envs.containsKey(StsFetcherConfigOptions.STS_CREDENTIAL_PROVIDER.getKey()) ? envs.get(StsFetcherConfigOptions.STS_CREDENTIAL_PROVIDER.getKey()) : envs.get(StsFetcherConfigOptions.ALICLOUD_STS_CREDENTIAL_PROVIDER.getKey());
        StsCredentialRetriever stsCredentialRetriever = null;
        switch (alicloudStsCredentialProvider) {
            case "sts.file": {
                stsCredentialRetriever = new StsCredentialFileRetriever();
                break;
            }
            case "sts.http": {
                stsCredentialRetriever = new StsCredentialHttpRetriever();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Can't find sts credential fetcher for provider: [%s]", alicloudStsCredentialProvider));
            }
        }
        stsCredentialRetriever.initialize(envs);
        return stsCredentialRetriever.getStsCredential();
    }

    public static StsCredential getStsCredentialViaJvmOpts(Properties properties) {
        return StsFetcher.getStsCredentialViaEnv(StsFetcher.toMap(properties));
    }

    private static Map<String, String> toMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString(), v.toString())));
        return map;
    }
}

