/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.core.utils.StringUtils;
import java.util.HashMap;
import java.util.Objects;

public class Credential
implements ICredential {
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String securityToken;
    public static final Credential ANONYMOUS_CREDENTIALS = Credential.builder().accessKeyId(null).accessKeyId(null).securityToken(null).build();

    private Credential(Builder builder) {
        this.accessKeyId = builder.accessKeyId;
        this.accessKeySecret = builder.accessKeySecret;
        this.securityToken = builder.securityToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String accessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public String accessKeySecret() {
        return this.accessKeySecret;
    }

    @Override
    public String securityToken() {
        return this.securityToken;
    }

    public String toString() {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("accessKeyId", this.accessKeyId);
        fieldMap.put("accessKeySecret", this.accessKeySecret);
        fieldMap.put("securityToken", this.securityToken);
        return StringUtils.toAliString("Credential", fieldMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credential that = (Credential)o;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.accessKeySecret, that.accessKeySecret);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeySecret());
        return hashCode;
    }

    public static final class Builder {
        private String accessKeyId;
        private String accessKeySecret;
        private String securityToken;

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder accessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public Builder securityToken(String securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        public Credential build() {
            return new Credential(this);
        }
    }
}

