/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.alibaba.ververica.connectors.kafka.catalog.shaded.com.google.gson.Gson;
import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.http.CompatibleUrlConnClient;
import com.aliyun.auth.credentials.http.HttpRequest;
import com.aliyun.auth.credentials.http.HttpResponse;
import com.aliyun.auth.credentials.http.MethodType;
import com.aliyun.auth.credentials.provider.HttpCredentialProvider;
import com.aliyun.auth.credentials.utils.ParameterHelper;
import com.aliyun.auth.credentials.utils.RefreshResult;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.core.utils.Validate;
import java.time.Instant;
import java.util.Map;

public final class RamRoleArnCredentialProvider
extends HttpCredentialProvider {
    private int durationSeconds;
    private String roleArn;
    private final String roleSessionName;
    private String regionId;
    private String policy;
    private int connectionTimeout;
    private int readTimeout;
    private int ramRoleArnTimeout;
    private volatile int ramRoleArnTimes = 0;
    private Credential credential;

    private RamRoleArnCredentialProvider(BuilderImpl builder) {
        super(builder);
        this.roleSessionName = builder.roleSessionName;
        this.durationSeconds = builder.durationSeconds;
        this.roleArn = builder.roleArn;
        this.regionId = builder.regionId;
        this.policy = builder.policy;
        this.connectionTimeout = builder.connectionTimeout;
        this.readTimeout = builder.readTimeout;
        this.ramRoleArnTimeout = builder.ramRoleArnTimeout;
        this.credential = Validate.notNull(builder.credential, "Credentials must not be null.", new Object[0]);
        this.buildRefreshCache();
    }

    public static RamRoleArnCredentialProvider create(Credential credential) {
        return RamRoleArnCredentialProvider.builder().credential(credential).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public RefreshResult<ICredential> refreshCredentials() {
        CompatibleUrlConnClient client = new CompatibleUrlConnClient();
        ParameterHelper parameterHelper = new ParameterHelper();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrlParameter("Action", "AssumeRole");
        httpRequest.setUrlParameter("Format", "JSON");
        httpRequest.setUrlParameter("Version", "2015-04-01");
        httpRequest.setUrlParameter("DurationSeconds", String.valueOf(this.durationSeconds));
        httpRequest.setUrlParameter("RoleArn", this.roleArn);
        httpRequest.setUrlParameter("AccessKeyId", this.credential.accessKeyId());
        httpRequest.setUrlParameter("RegionId", this.regionId);
        httpRequest.setUrlParameter("RoleSessionName", this.roleSessionName);
        if (this.policy != null) {
            httpRequest.setUrlParameter("Policy", this.policy);
        }
        httpRequest.setSysMethod(MethodType.GET);
        httpRequest.setSysConnectTimeout(this.connectionTimeout);
        httpRequest.setSysReadTimeout(this.readTimeout);
        String strToSign = parameterHelper.composeStringToSign(MethodType.GET, httpRequest.getUrlParameters());
        String signature = parameterHelper.signString(strToSign, this.credential.accessKeySecret() + "&");
        httpRequest.setUrlParameter("Signature", signature);
        httpRequest.setSysUrl(parameterHelper.composeUrl("sts.aliyuncs.com", httpRequest.getUrlParameters(), "https"));
        HttpResponse httpResponse = client.syncInvoke(httpRequest);
        Gson gson = new Gson();
        Map map = gson.fromJson(httpResponse.getHttpContentString(), Map.class);
        if (map.containsKey("Credentials")) {
            Map credentials = (Map)map.get("Credentials");
            Instant expiration = ParameterHelper.getUTCDate((String)credentials.get("Expiration")).toInstant();
            Credential credential = Credential.builder().accessKeyId((String)credentials.get("AccessKeyId")).accessKeySecret((String)credentials.get("AccessKeySecret")).securityToken((String)credentials.get("SecurityToken")).build();
            return RefreshResult.builder(credential).staleTime(this.getStaleTime(expiration)).prefetchTime(this.getPrefetchTime(expiration)).build();
        }
        throw new CredentialException(gson.toJson(map));
    }

    private static final class BuilderImpl
    extends HttpCredentialProvider.BuilderImpl<RamRoleArnCredentialProvider, Builder>
    implements Builder {
        private String roleSessionName = "defaultSessionName";
        private int durationSeconds = 3600;
        private String roleArn;
        private String regionId = "cn-hangzhou";
        private String policy;
        private int connectionTimeout = 1000;
        private int readTimeout = 1000;
        private int ramRoleArnTimeout = 1000;
        private Credential credential;

        private BuilderImpl() {
        }

        @Override
        public Builder roleSessionName(String roleSessionName) {
            if (!StringUtils.isEmpty(roleSessionName)) {
                this.roleSessionName = roleSessionName;
            }
            return this;
        }

        @Override
        public Builder durationSeconds(int durationSeconds) {
            if (!StringUtils.isEmpty(durationSeconds)) {
                this.durationSeconds = durationSeconds;
            }
            return this;
        }

        @Override
        public Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder regionId(String regionId) {
            if (!StringUtils.isEmpty(regionId)) {
                this.regionId = regionId;
            }
            return this;
        }

        @Override
        public Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public Builder connectionTimeout(int connectionTimeout) {
            if (!StringUtils.isEmpty(connectionTimeout)) {
                this.connectionTimeout = connectionTimeout;
            }
            return this;
        }

        @Override
        public Builder readTimeout(int readTimeout) {
            if (!StringUtils.isEmpty(readTimeout)) {
                this.readTimeout = readTimeout;
            }
            return this;
        }

        @Override
        public Builder ramRoleArnTimeout(int ramRoleArnTimeout) {
            if (!StringUtils.isEmpty(ramRoleArnTimeout)) {
                this.ramRoleArnTimeout = ramRoleArnTimeout;
            }
            return this;
        }

        @Override
        public Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        @Override
        public RamRoleArnCredentialProvider build() {
            return new RamRoleArnCredentialProvider(this);
        }
    }

    public static interface Builder
    extends HttpCredentialProvider.Builder<RamRoleArnCredentialProvider, Builder> {
        public Builder roleSessionName(String var1);

        public Builder durationSeconds(int var1);

        public Builder roleArn(String var1);

        public Builder regionId(String var1);

        public Builder policy(String var1);

        public Builder connectionTimeout(int var1);

        public Builder readTimeout(int var1);

        public Builder ramRoleArnTimeout(int var1);

        public Builder credential(Credential var1);

        @Override
        public RamRoleArnCredentialProvider build();
    }
}

