/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.alibaba.ververica.connectors.kafka.catalog.shaded.com.google.gson.Gson;
import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.http.CompatibleUrlConnClient;
import com.aliyun.auth.credentials.http.HttpRequest;
import com.aliyun.auth.credentials.http.HttpResponse;
import com.aliyun.auth.credentials.http.MethodType;
import com.aliyun.auth.credentials.provider.HttpCredentialProvider;
import com.aliyun.auth.credentials.utils.ParameterHelper;
import com.aliyun.auth.credentials.utils.RefreshResult;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.core.utils.Validate;
import java.time.Instant;
import java.util.Map;

public final class RsaKeyPairCredentialProvider
extends HttpCredentialProvider {
    private int durationSeconds;
    private String regionId;
    private int connectionTimeout;
    private int readTimeout;
    private Credential credential;

    private RsaKeyPairCredentialProvider(BuilderImpl builder) {
        super(builder);
        this.durationSeconds = builder.durationSeconds;
        this.regionId = builder.regionId;
        this.connectionTimeout = builder.connectionTimeout;
        this.readTimeout = builder.readTimeout;
        this.credential = Validate.notNull(builder.credential, "Credentials must not be null.", new Object[0]);
        this.buildRefreshCache();
    }

    public static RsaKeyPairCredentialProvider create(Credential credential) {
        return RsaKeyPairCredentialProvider.builder().credential(credential).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public RefreshResult<ICredential> refreshCredentials() {
        CompatibleUrlConnClient client = new CompatibleUrlConnClient();
        ParameterHelper parameterHelper = new ParameterHelper();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrlParameter("Action", "GenerateSessionAccessKey");
        httpRequest.setUrlParameter("Format", "JSON");
        httpRequest.setUrlParameter("Version", "2015-04-01");
        httpRequest.setUrlParameter("DurationSeconds", String.valueOf(this.durationSeconds));
        httpRequest.setUrlParameter("AccessKeyId", this.credential.accessKeyId());
        httpRequest.setUrlParameter("RegionId", this.regionId);
        String strToSign = parameterHelper.composeStringToSign(MethodType.GET, httpRequest.getUrlParameters());
        String signature = parameterHelper.signString(strToSign, this.credential.accessKeySecret() + "&");
        httpRequest.setUrlParameter("Signature", signature);
        httpRequest.setSysMethod(MethodType.GET);
        httpRequest.setSysConnectTimeout(this.connectionTimeout);
        httpRequest.setSysReadTimeout(this.readTimeout);
        httpRequest.setSysUrl(parameterHelper.composeUrl("sts.aliyuncs.com", httpRequest.getUrlParameters(), "https"));
        HttpResponse httpResponse = client.syncInvoke(httpRequest);
        Gson gson = new Gson();
        Map map = gson.fromJson(httpResponse.getHttpContentString(), Map.class);
        if (map.containsKey("SessionAccessKey")) {
            Map credentials = (Map)map.get("SessionAccessKey");
            Instant expiration = ParameterHelper.getUTCDate((String)credentials.get("Expiration")).toInstant();
            Credential credential = Credential.builder().accessKeyId((String)credentials.get("SessionAccessKeyId")).accessKeySecret((String)credentials.get("SessionAccessKeySecret")).build();
            return RefreshResult.builder(credential).staleTime(this.getStaleTime(expiration)).prefetchTime(this.getPrefetchTime(expiration)).build();
        }
        throw new CredentialException(gson.toJson(map));
    }

    private static final class BuilderImpl
    extends HttpCredentialProvider.BuilderImpl<RsaKeyPairCredentialProvider, Builder>
    implements Builder {
        private int durationSeconds = 3600;
        private String regionId = "cn-hangzhou";
        private int connectionTimeout = 1000;
        private int readTimeout = 1000;
        private Credential credential;

        private BuilderImpl() {
        }

        @Override
        public Builder durationSeconds(int durationSeconds) {
            if (!StringUtils.isEmpty(durationSeconds)) {
                this.durationSeconds = durationSeconds;
            }
            return this;
        }

        @Override
        public Builder regionId(String regionId) {
            if (!StringUtils.isEmpty(regionId)) {
                this.regionId = regionId;
            }
            return this;
        }

        @Override
        public Builder connectionTimeout(int connectionTimeout) {
            if (!StringUtils.isEmpty(connectionTimeout)) {
                this.connectionTimeout = connectionTimeout;
            }
            return this;
        }

        @Override
        public Builder readTimeout(int readTimeout) {
            if (!StringUtils.isEmpty(readTimeout)) {
                this.readTimeout = readTimeout;
            }
            return this;
        }

        @Override
        public Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        @Override
        public RsaKeyPairCredentialProvider build() {
            return new RsaKeyPairCredentialProvider(this);
        }
    }

    public static interface Builder
    extends HttpCredentialProvider.Builder<RsaKeyPairCredentialProvider, Builder> {
        public Builder durationSeconds(int var1);

        public Builder regionId(String var1);

        public Builder connectionTimeout(int var1);

        public Builder readTimeout(int var1);

        public Builder credential(Credential var1);

        @Override
        public RsaKeyPairCredentialProvider build();
    }
}

