/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.httpcomponent.httpclient.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;

public final class StreamEntityProducer
implements AsyncEntityProducer {
    private InputStream data;
    private long contentLength;
    private ByteBuffer buffer;
    private boolean gotEOF;

    public StreamEntityProducer(InputStream inputstream) {
        this.data = inputstream;
        this.gotEOF = false;
        this.buffer = null;
        this.contentLength = -1L;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public void failed(Exception e) {
        this.releaseResources();
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public boolean isChunked() {
        return this.contentLength == -1L;
    }

    @Override
    public Set<String> getTrailerNames() {
        return null;
    }

    @Override
    public int available() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void produce(DataStreamChannel dataStreamChannel) throws IOException {
        this.fillBuffer();
        while (this.buffer != null && this.buffer.remaining() > 0) {
            dataStreamChannel.write(this.buffer);
            if (this.buffer.remaining() > 0) break;
            this.fillBuffer();
        }
        if (this.gotEOF && (this.buffer == null || !this.buffer.hasRemaining())) {
            dataStreamChannel.endStream();
        }
    }

    @Override
    public void releaseResources() {
    }

    private void fillBuffer() throws IOException {
        if (this.buffer == null || !this.buffer.hasRemaining()) {
            byte[] src = new byte[4096];
            int ret = this.data.read(src);
            if (ret < 0) {
                this.gotEOF = true;
                return;
            }
            this.buffer = ByteBuffer.wrap(src, 0, ret);
        }
    }
}

