/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.httpcomponent.httpclient.implementation.reactive;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.http.HttpResponse;
import com.aliyun.httpcomponent.httpclient.implementation.reactive.ReactiveApacheHttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hc.core5.http.Header;

public final class ReactiveHttpResponse
extends HttpResponse {
    private final int statusCode;
    private final HttpHeaders headers;

    public ReactiveHttpResponse(HttpRequest request, ReactiveApacheHttpResponse apacheResponse) {
        super(request);
        this.statusCode = apacheResponse.getCode();
        this.headers = apacheResponse.getSDKHttpHeaders() == null ? ReactiveHttpResponse.toHeaders(apacheResponse) : apacheResponse.getSDKHttpHeaders();
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public ByteBuffer getBody() {
        return null;
    }

    @Override
    public byte[] getBodyAsByteArray() {
        return null;
    }

    @Override
    public String getBodyAsString() {
        return null;
    }

    @Override
    public String getBodyAsString(Charset charset) {
        return null;
    }

    private static HttpHeaders toHeaders(ReactiveApacheHttpResponse response) {
        Header[] apacheHeaders;
        HttpHeaders httpHeaders = new HttpHeaders();
        HashSet<String> nameSet = new HashSet<String>();
        for (Header header : apacheHeaders = response.getHeaders()) {
            nameSet.add(header.getName());
        }
        nameSet.forEach(name -> {
            Header[] entityHeaders = response.getHeaders((String)name);
            ArrayList<String> values = new ArrayList<String>();
            for (Header entityHeader : entityHeaders) {
                values.add(entityHeader.getValue());
            }
            httpHeaders.set((String)name, (List<String>)values);
        });
        return httpHeaders;
    }
}

