/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.httpcomponent.httpclient.implementation.reactive;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpResponseHandler;
import com.aliyun.httpcomponent.httpclient.implementation.reactive.ReactiveApacheHttpResponse;
import com.aliyun.httpcomponent.httpclient.implementation.reactive.ReactiveDataConsumer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;

public final class ReactiveResponseConsumer
implements AsyncResponseConsumer<ReactiveApacheHttpResponse> {
    private final ReactiveDataConsumer reactiveDataConsumer = new ReactiveDataConsumer();
    private final List<Header> trailers = Collections.synchronizedList(new ArrayList());
    private volatile BasicFuture<ReactiveApacheHttpResponse> responseCompletion;
    private volatile HttpResponse informationResponse;
    private volatile EntityDetails entityDetails;
    private HttpResponseHandler handler;
    private HttpResponse response;
    private HttpHeaders sdkHttpHeaders;

    public ReactiveResponseConsumer(HttpResponseHandler handler) {
        this.handler = handler;
    }

    public HttpResponse getInformationResponse() {
        return this.informationResponse;
    }

    public EntityDetails getEntityDetails() {
        return this.entityDetails;
    }

    public List<Header> getTrailers() {
        return this.trailers;
    }

    @Override
    public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext httpContext, FutureCallback<ReactiveApacheHttpResponse> resultCallback) {
        this.response = response;
        this.entityDetails = entityDetails;
        this.responseCompletion = new BasicFuture<ReactiveApacheHttpResponse>(resultCallback);
        this.sdkHttpHeaders = ReactiveResponseConsumer.toHeaders(response);
        this.handler.onStream(this.reactiveDataConsumer, response.getCode(), this.sdkHttpHeaders);
        if (entityDetails == null) {
            this.streamEnd(null);
        }
    }

    @Override
    public void informationResponse(HttpResponse response, HttpContext httpContext) {
        this.informationResponse = response;
    }

    @Override
    public void failed(Exception cause) {
        this.reactiveDataConsumer.failed(cause);
        if (this.responseCompletion != null) {
            this.responseCompletion.failed(cause);
        }
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.reactiveDataConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public void consume(ByteBuffer src) throws IOException {
        this.reactiveDataConsumer.consume(src);
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) {
        if (trailers != null) {
            this.trailers.addAll(trailers);
        }
        this.reactiveDataConsumer.streamEnd(trailers);
        ReactiveApacheHttpResponse result = ReactiveApacheHttpResponse.copyLite(this.response, this.sdkHttpHeaders);
        if (this.responseCompletion != null) {
            this.responseCompletion.completed(result);
        }
    }

    @Override
    public void releaseResources() {
        this.reactiveDataConsumer.releaseResources();
        if (this.responseCompletion != null) {
            this.responseCompletion.cancel();
        }
    }

    private static HttpHeaders toHeaders(HttpResponse response) {
        Header[] apacheHeaders;
        HttpHeaders httpHeaders = new HttpHeaders();
        HashSet<String> nameSet = new HashSet<String>();
        for (Header header : apacheHeaders = response.getHeaders()) {
            nameSet.add(header.getName());
        }
        nameSet.forEach(name -> {
            Header[] entityHeaders = response.getHeaders((String)name);
            ArrayList<String> values = new ArrayList<String>();
            for (Header entityHeader : entityHeaders) {
                values.add(entityHeader.getValue());
            }
            httpHeaders.set((String)name, (List<String>)values);
        });
        return httpHeaders;
    }
}

