/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.auth;

import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class RoaSignatureComposer {
    private static final String SEPARATOR = "&";
    private static final String ACCEPT = "accept";
    private static final String CONTENT_MD5 = "content-md5";
    private static final String CONTENT_TYPE = "content-type";
    private static final String DATE = "date";
    private static final String prefix = "x-acs-";

    public static String composeStringToSign(HttpMethod method, Map<String, String> params, Map<String, String> headers, String pathname) {
        String accept = headers.get(ACCEPT) == null ? "" : headers.get(ACCEPT);
        String contentMD5 = headers.get(CONTENT_MD5) == null ? "" : headers.get(CONTENT_MD5);
        String contentType = headers.get(CONTENT_TYPE) == null ? "" : headers.get(CONTENT_TYPE);
        String date = headers.get(DATE) == null ? "" : headers.get(DATE);
        String header = (Object)((Object)method) + "\n" + accept + "\n" + contentMD5 + "\n" + contentType + "\n" + date + "\n";
        String canonicalizedHeaders = RoaSignatureComposer.buildCanonicalizedHeaders(headers);
        String canonicalizedResource = RoaSignatureComposer.buildCanonicalizedResource(pathname, params);
        return header + canonicalizedHeaders + canonicalizedResource;
    }

    private static String buildCanonicalizedHeaders(Map<String, String> headers) {
        Set<String> keys = headers.keySet();
        ArrayList<String> canonicalizedKeys = new ArrayList<String>();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            canonicalizedKeys.add(key);
        }
        Collections.sort(canonicalizedKeys);
        StringBuilder canonicalizedHeaders = new StringBuilder();
        for (String key : canonicalizedKeys) {
            canonicalizedHeaders.append(key);
            canonicalizedHeaders.append(":");
            canonicalizedHeaders.append(headers.get(key).trim());
            canonicalizedHeaders.append("\n");
        }
        return canonicalizedHeaders.toString();
    }

    private static String buildCanonicalizedResource(String pathname, Map<String, String> params) {
        if (params.size() <= 0) {
            return pathname;
        }
        Object[] keys = params.keySet().toArray(new String[params.size()]);
        StringBuilder queryString = new StringBuilder(pathname);
        queryString.append("?");
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            queryString.append((String)keys[i]);
            if (!StringUtils.isEmpty(params.get(keys[i]))) {
                queryString.append("=");
                queryString.append(params.get(keys[i]));
            }
            queryString.append(SEPARATOR);
        }
        return queryString.length() > 0 ? queryString.deleteCharAt(queryString.length() - 1).toString() : "";
    }
}

