/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.auth;

import com.aliyun.auth.signature.exception.SignatureException;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.utils.EncodeUtil;
import com.aliyun.core.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class V3SignatureComposer {
    private static final String UTF8 = "UTF-8";
    private static final String SEPARATOR = "&";
    private static final String DELIMITER = ";";
    private static final String prefix = "x-acs-";
    private static final String CONTENT_TYPE = "content-type";
    private static final String HOST = "host";

    public static String composeStringToSign(HttpMethod method, Map<String, String> params, Map<String, String> headers, String pathname, String payload) {
        String canonicalURI = pathname;
        if (StringUtils.isBlank(canonicalURI)) {
            canonicalURI = "/";
        }
        String queryString = V3SignatureComposer.getCanonicalizedResource(params);
        StringBuilder sb = new StringBuilder(method.toString());
        sb.append("\n").append(canonicalURI).append("\n").append(queryString).append("\n").append(V3SignatureComposer.buildCanonicalizedHeaders(headers)).append("\n").append(V3SignatureComposer.buildSignedHeaders(headers)).append("\n").append(payload);
        return sb.toString();
    }

    private static String buildCanonicalizedHeaders(Map<String, String> headers) {
        Set<String> keys = headers.keySet();
        ArrayList<String> canonicalizedKeys = new ArrayList<String>();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (String key : keys) {
            String lowerKey = key.toLowerCase();
            if (!lowerKey.startsWith(prefix) && !lowerKey.equals(HOST) && !lowerKey.equals(CONTENT_TYPE)) continue;
            if (!canonicalizedKeys.contains(lowerKey)) {
                canonicalizedKeys.add(lowerKey);
            }
            valueMap.put(lowerKey, headers.get(key).trim());
        }
        Object[] canonicalizedKeysArray = canonicalizedKeys.toArray(new String[canonicalizedKeys.size()]);
        Arrays.sort(canonicalizedKeysArray);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < canonicalizedKeysArray.length; ++i) {
            Object key = canonicalizedKeysArray[i];
            sb.append((String)key);
            sb.append(":");
            sb.append((String)valueMap.get(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String buildSignedHeaders(Map<String, String> headers) {
        Object[] keys = headers.keySet().toArray(new String[headers.size()]);
        Arrays.sort(keys);
        ArrayList<String> canonicalizedKeys = new ArrayList<String>();
        for (Object key : keys) {
            String lowerKey = ((String)key).toLowerCase();
            if (!lowerKey.startsWith(prefix) && !lowerKey.equals(HOST) && !lowerKey.equals(CONTENT_TYPE) || canonicalizedKeys.contains(lowerKey)) continue;
            canonicalizedKeys.add(lowerKey);
        }
        String[] canonicalizedKeysArray = canonicalizedKeys.toArray(new String[canonicalizedKeys.size()]);
        return StringUtils.join(DELIMITER, Arrays.asList(canonicalizedKeysArray));
    }

    private static String getCanonicalizedResource(Map<String, String> query) {
        if (query == null || query.size() == 0) {
            return "";
        }
        Object[] keys = query.keySet().toArray(new String[query.size()]);
        Arrays.sort(keys);
        StringBuilder queryString = new StringBuilder();
        try {
            for (int i = 0; i < keys.length; ++i) {
                queryString.append(EncodeUtil.percentEncode((String)keys[i]));
                queryString.append("=");
                if (!StringUtils.isEmpty(query.get(keys[i]))) {
                    queryString.append(EncodeUtil.percentEncode(query.get(keys[i])));
                }
                queryString.append(SEPARATOR);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e.toString());
        }
        return queryString.length() > 0 ? queryString.deleteCharAt(queryString.length() - 1).toString() : "";
    }
}

