/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.auth.signer;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.signature.SignerParams;
import com.aliyun.auth.signature.signer.SignAlgorithmHmacSHA256;
import com.aliyun.auth.signature.signer.SignAlgorithmHmacSM3;
import com.aliyun.auth.signature.signer.SignAlgorithmSHA256withRSA;
import com.aliyun.core.utils.EncodeUtil;
import com.aliyun.sdk.gateway.pop.auth.SignatureAlgorithm;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.auth.signer.PopSigner;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PopV3Signer
implements PopSigner {
    private final String ENCODING = "UTF-8";
    private final String HASH_SHA256 = "SHA-256";
    private final String HASH_SM3 = "SM3";
    private final String PEM_BEGIN = "-----BEGIN RSA PRIVATE KEY-----\n";
    private final String PEM_END = "\n-----END RSA PRIVATE KEY-----";
    private final SignatureAlgorithm DEFAULT_ALGORITHM;
    private final SignatureAlgorithm algorithm;

    public PopV3Signer() {
        this.algorithm = this.DEFAULT_ALGORITHM = SignatureAlgorithm.ACS3_HMAC_SHA256;
    }

    public PopV3Signer(SignatureAlgorithm algorithm) {
        this.DEFAULT_ALGORITHM = SignatureAlgorithm.ACS3_HMAC_SHA256;
        this.algorithm = algorithm != null ? algorithm : this.DEFAULT_ALGORITHM;
    }

    @Override
    public String signString(String stringToSign, SignerParams params) {
        ICredential credential = params.credentials();
        String accessKeySecret = credential.accessKeySecret();
        try {
            switch (this.algorithm) {
                case ACS3_HMAC_SM3: {
                    HMac sm3HMAC = SignAlgorithmHmacSM3.HMAC_SM3.getMac();
                    SecretKeySpec key = new SecretKeySpec(accessKeySecret.getBytes("UTF-8"), SignAlgorithmHmacSM3.HMAC_SM3.toString());
                    byte[] sm3Sign = new byte[sm3HMAC.getMacSize()];
                    byte[] inputBytes = stringToSign.getBytes("UTF-8");
                    sm3HMAC.init((CipherParameters)new KeyParameter(key.getEncoded()));
                    sm3HMAC.update(inputBytes, 0, inputBytes.length);
                    sm3HMAC.doFinal(sm3Sign, 0);
                    return EncodeUtil.hexEncode(sm3Sign);
                }
                case ACS3_RSA_SHA256: {
                    Signature rsaSign = SignAlgorithmSHA256withRSA.SHA256withRSA.getSignature();
                    KeyFactory kf = KeyFactory.getInstance(SignAlgorithmSHA256withRSA.SHA256withRSA.toString());
                    byte[] keySpec = Base64.getDecoder().decode(this.checkRSASecret(accessKeySecret));
                    PrivateKey privateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(keySpec));
                    rsaSign.initSign(privateKey);
                    rsaSign.update(stringToSign.getBytes("UTF-8"));
                    byte[] sign = rsaSign.sign();
                    return EncodeUtil.hexEncode(sign);
                }
            }
            Mac sha256HMAC = SignAlgorithmHmacSHA256.HmacSHA256.getMac();
            sha256HMAC.init(new SecretKeySpec(accessKeySecret.getBytes("UTF-8"), SignAlgorithmHmacSHA256.HmacSHA256.toString()));
            return EncodeUtil.hexEncode(sha256HMAC.doFinal(stringToSign.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new com.aliyun.auth.signature.exception.SignatureException(e.toString());
        }
    }

    private String checkRSASecret(String accessKeySecret) {
        if (accessKeySecret != null) {
            if (accessKeySecret.startsWith("-----BEGIN RSA PRIVATE KEY-----\n")) {
                accessKeySecret = accessKeySecret.replace("-----BEGIN RSA PRIVATE KEY-----\n", "");
            }
            while (accessKeySecret.endsWith("\n") || accessKeySecret.endsWith("\r")) {
                accessKeySecret = accessKeySecret.substring(0, accessKeySecret.length() - 1);
            }
            if (accessKeySecret.endsWith("\n-----END RSA PRIVATE KEY-----")) {
                accessKeySecret = accessKeySecret.replace("\n-----END RSA PRIVATE KEY-----", "");
            }
        }
        return accessKeySecret;
    }

    @Override
    public byte[] hash(byte[] raw) {
        if (null == raw) {
            return null;
        }
        try {
            MessageDigest digest;
            switch (this.algorithm) {
                case ACS3_HMAC_SM3: {
                    BouncyCastleProvider provider = new BouncyCastleProvider();
                    digest = MessageDigest.getInstance("SM3", (Provider)provider);
                    break;
                }
                default: {
                    digest = MessageDigest.getInstance("SHA-256");
                }
            }
            return digest.digest(raw);
        }
        catch (NoSuchAlgorithmException e) {
            throw new com.aliyun.auth.signature.exception.SignatureException(e.toString());
        }
    }

    @Override
    public String getContent() {
        switch (this.algorithm) {
            case ACS3_HMAC_SM3: {
                return "x-acs-content-sm3";
            }
        }
        return "x-acs-content-sha256";
    }

    @Override
    public SignatureAlgorithm getSignerName() {
        return this.algorithm;
    }

    @Override
    public SignatureVersion getSignerVersion() {
        return SignatureVersion.V3;
    }
}

