/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alikafka20190916.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class CreateTopicRequest
extends Request {
    @Query
    @NameInMap(value="CompactTopic")
    private Boolean compactTopic;
    @Query
    @NameInMap(value="Config")
    private Map<String, ?> config;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="LocalTopic")
    private Boolean localTopic;
    @Query
    @NameInMap(value="MinInsyncReplicas")
    @Validation(maximum=3.0, minimum=1.0)
    private Long minInsyncReplicas;
    @Query
    @NameInMap(value="PartitionNum")
    private String partitionNum;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="Remark")
    @Validation(required=true)
    private String remark;
    @Query
    @NameInMap(value="ReplicationFactor")
    @Validation(maximum=3.0, minimum=1.0)
    private Long replicationFactor;
    @Query
    @NameInMap(value="Topic")
    @Validation(required=true)
    private String topic;

    private CreateTopicRequest(Builder builder) {
        super(builder);
        this.compactTopic = builder.compactTopic;
        this.config = builder.config;
        this.instanceId = builder.instanceId;
        this.localTopic = builder.localTopic;
        this.minInsyncReplicas = builder.minInsyncReplicas;
        this.partitionNum = builder.partitionNum;
        this.regionId = builder.regionId;
        this.remark = builder.remark;
        this.replicationFactor = builder.replicationFactor;
        this.topic = builder.topic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateTopicRequest create() {
        return CreateTopicRequest.builder().build();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public Boolean getCompactTopic() {
        return this.compactTopic;
    }

    public Map<String, ?> getConfig() {
        return this.config;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Boolean getLocalTopic() {
        return this.localTopic;
    }

    public Long getMinInsyncReplicas() {
        return this.minInsyncReplicas;
    }

    public String getPartitionNum() {
        return this.partitionNum;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getRemark() {
        return this.remark;
    }

    public Long getReplicationFactor() {
        return this.replicationFactor;
    }

    public String getTopic() {
        return this.topic;
    }

    public static final class Builder
    extends Request.Builder<CreateTopicRequest, Builder> {
        private Boolean compactTopic;
        private Map<String, ?> config;
        private String instanceId;
        private Boolean localTopic;
        private Long minInsyncReplicas;
        private String partitionNum;
        private String regionId;
        private String remark;
        private Long replicationFactor;
        private String topic;

        private Builder() {
        }

        private Builder(CreateTopicRequest request) {
            super(request);
            this.compactTopic = request.compactTopic;
            this.config = request.config;
            this.instanceId = request.instanceId;
            this.localTopic = request.localTopic;
            this.minInsyncReplicas = request.minInsyncReplicas;
            this.partitionNum = request.partitionNum;
            this.regionId = request.regionId;
            this.remark = request.remark;
            this.replicationFactor = request.replicationFactor;
            this.topic = request.topic;
        }

        public Builder compactTopic(Boolean compactTopic) {
            this.putQueryParameter("CompactTopic", compactTopic);
            this.compactTopic = compactTopic;
            return this;
        }

        public Builder config(Map<String, ?> config) {
            String configShrink = this.shrink(config, "Config", "json");
            this.putQueryParameter("Config", configShrink);
            this.config = config;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder localTopic(Boolean localTopic) {
            this.putQueryParameter("LocalTopic", localTopic);
            this.localTopic = localTopic;
            return this;
        }

        public Builder minInsyncReplicas(Long minInsyncReplicas) {
            this.putQueryParameter("MinInsyncReplicas", minInsyncReplicas);
            this.minInsyncReplicas = minInsyncReplicas;
            return this;
        }

        public Builder partitionNum(String partitionNum) {
            this.putQueryParameter("PartitionNum", partitionNum);
            this.partitionNum = partitionNum;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder remark(String remark) {
            this.putQueryParameter("Remark", remark);
            this.remark = remark;
            return this;
        }

        public Builder replicationFactor(Long replicationFactor) {
            this.putQueryParameter("ReplicationFactor", replicationFactor);
            this.replicationFactor = replicationFactor;
            return this;
        }

        public Builder topic(String topic) {
            this.putQueryParameter("Topic", topic);
            this.topic = topic;
            return this;
        }

        @Override
        public CreateTopicRequest build() {
            return new CreateTopicRequest(this);
        }
    }
}

