/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.alikafka20190916.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class GetTopicListRequest
extends Request {
    @Query
    @NameInMap(value="CurrentPage")
    private String currentPage;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="PageSize")
    private String pageSize;
    @Query
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="Topic")
    private String topic;

    private GetTopicListRequest(Builder builder) {
        super(builder);
        this.currentPage = builder.currentPage;
        this.instanceId = builder.instanceId;
        this.pageSize = builder.pageSize;
        this.regionId = builder.regionId;
        this.topic = builder.topic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetTopicListRequest create() {
        return GetTopicListRequest.builder().build();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCurrentPage() {
        return this.currentPage;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getTopic() {
        return this.topic;
    }

    public static final class Builder
    extends Request.Builder<GetTopicListRequest, Builder> {
        private String currentPage;
        private String instanceId;
        private String pageSize;
        private String regionId;
        private String topic;

        private Builder() {
        }

        private Builder(GetTopicListRequest request) {
            super(request);
            this.currentPage = request.currentPage;
            this.instanceId = request.instanceId;
            this.pageSize = request.pageSize;
            this.regionId = request.regionId;
            this.topic = request.topic;
        }

        public Builder currentPage(String currentPage) {
            this.putQueryParameter("CurrentPage", currentPage);
            this.currentPage = currentPage;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder pageSize(String pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder topic(String topic) {
            this.putQueryParameter("Topic", topic);
            this.topic = topic;
            return this;
        }

        @Override
        public GetTopicListRequest build() {
            return new GetTopicListRequest(this);
        }
    }
}

