/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core;

import com.aliyun.core.http.HttpClient;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.http.HttpResponseHandler;
import com.aliyun.core.logging.ClientLogger;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.Context;
import com.aliyun.core.utils.SdkAutoCloseable;
import com.aliyun.core.utils.Validate;
import com.aliyun.httpcomponent.httpclient.ApacheAsyncHttpClientBuilder;
import darabonba.core.RequestModel;
import darabonba.core.TeaConfiguration;
import darabonba.core.TeaModel;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientExecutionParams;
import darabonba.core.client.ClientOption;
import darabonba.core.client.IAsyncHandler;
import darabonba.core.exception.ClientException;
import darabonba.core.exception.TeaException;
import darabonba.core.interceptor.InterceptorChain;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.internal.AttributeKey;
import darabonba.core.policy.retry.RetryPolicy;
import darabonba.core.policy.retry.RetryPolicyContext;
import darabonba.core.utils.CommonUtil;
import darabonba.core.utils.ModelUtil;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class TeaAsyncHandler
implements IAsyncHandler,
SdkAutoCloseable {
    private final String RESPONSE_HANDLER_KEY = "RESPONSE_HANDLER";
    private final ClientLogger logger = new ClientLogger(TeaAsyncHandler.class);
    private final ClientConfiguration configuration;
    private HttpClient httpClient;

    public TeaAsyncHandler(ClientConfiguration config) {
        this.httpClient = this.resolveHttpClient(config);
        Validate.notNull(config.option(ClientOption.CREDENTIALS_PROVIDER), "Credentials must not be null.", new Object[0]);
        this.configuration = config;
    }

    private HttpClient resolveHttpClient(ClientConfiguration config) {
        return Optional.ofNullable(config.option(ClientOption.ASYNC_HTTP_CLIENT)).orElseGet(() -> new ApacheAsyncHttpClientBuilder().connectionTimeout(config.option(ClientOption.CONNECT_TIMEOUT)).responseTimeout(config.option(ClientOption.RESPONSE_TIMEOUT)).build());
    }

    private HttpRequest composeHttpRequest(InterceptorContext context) {
        TeaRequest request = context.teaRequest();
        TeaConfiguration configuration = context.configuration();
        HttpRequest httpRequest = context.httpRequest();
        if (CommonUtil.isUnset(httpRequest)) {
            httpRequest = new HttpRequest(Optional.ofNullable(configuration.method()).orElseGet(request::method), ModelUtil.composeUrl(configuration.endpoint(), request.query(), configuration.protocol(), request.pathname()));
            HttpHeaders httpHeaders = new HttpHeaders(request.headers());
            httpRequest.setHeaders(httpHeaders);
            if (request.body() instanceof byte[]) {
                httpRequest.setBody((byte[])request.body());
            }
        }
        httpRequest.setConnectTimeout(configuration.connectTimeout()).setResponseTimeout(configuration.responseTimeout());
        return httpRequest;
    }

    private Context composeHttpRequestContext(InterceptorContext context, AttributeMap attributes) {
        Context ctx = Context.NONE;
        HttpResponseHandler httpResponseHandler = null;
        if (attributes.containsKey(AttributeKey.HTTP_RESPONSE_HANDLER)) {
            httpResponseHandler = attributes.get(AttributeKey.HTTP_RESPONSE_HANDLER);
        }
        if (httpResponseHandler != null) {
            ctx = ctx.addData("RESPONSE_HANDLER", httpResponseHandler);
        }
        return ctx;
    }

    public void validateRequestModel(RequestModel model) {
        if (CommonUtil.isUnset(model)) {
            throw new TeaException("RequestModel is not allowed as null", new RuntimeException("RequestModel is not allowed as null"));
        }
        model.validate();
    }

    public HttpClient httpClient() {
        return this.httpClient;
    }

    public ClientConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public void close() {
        this.configuration.close();
        this.httpClient.close();
    }

    @Override
    public <InputT extends RequestModel, OutputT extends TeaModel> CompletableFuture<OutputT> execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        InterceptorChain interceptorChain = this.configuration.option(ClientOption.INTERCEPTOR_CHAIN);
        TeaConfiguration config = new TeaConfiguration(this.configuration, executionParams.getRequest().requestConfiguration());
        HttpHeaders headers = new HttpHeaders();
        headers.putAll(executionParams.getRequest().headers());
        headers.putAll(config.httpHeaders());
        TeaRequest request = executionParams.getRequest().copy().setHeaders(headers);
        InterceptorContext context = InterceptorContext.builder().teaRequest(request).teaRequestBody(executionParams.getRequestBody()).configuration(config).build();
        context.setOutput(executionParams.getOutput());
        context.setTeaResponseHandler(executionParams.getResponseHandler());
        AttributeMap attributes = AttributeMap.empty();
        context = interceptorChain.modifyConfiguration(context, attributes);
        context = interceptorChain.modifyRequest(context, attributes);
        RetryableExecutor executor = new RetryableExecutor(context, attributes, this.httpClient);
        return executor.execute().thenCompose(output -> CompletableFuture.completedFuture(output));
    }

    private class RetryableExecutor {
        private final ClientConfiguration configuration;
        private final HttpClient httpClient;
        private final RetryPolicy retryPolicy;
        private int attemptNumber;
        private Throwable lastException;
        private HttpResponse lastHttpResponse;
        private RetryPolicyContext retryContext;
        private AttributeMap attributes;
        private InterceptorContext interceptorContext;

        private RetryableExecutor(InterceptorContext interceptorContext, AttributeMap attributes, HttpClient httpClient) {
            this.configuration = interceptorContext.configuration().clientConfiguration();
            this.httpClient = httpClient;
            this.retryPolicy = this.configuration.option(ClientOption.RETRY_POLICY);
            this.attemptNumber = 0;
            this.lastException = null;
            this.lastHttpResponse = null;
            this.attributes = attributes;
            this.interceptorContext = interceptorContext;
        }

        public CompletableFuture<TeaModel> execute() {
            CompletableFuture<TeaModel> future = new CompletableFuture<TeaModel>();
            try {
                this.retryThenExecute(future);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            return future;
        }

        private void retryThenExecute(CompletableFuture<TeaModel> future) {
            ++this.attemptNumber;
            this.retryContext = RetryPolicyContext.builder().retriesAttempted(this.attemptNumber - 1).exception(this.lastException).httpResponse(this.lastHttpResponse).build();
            if (!this.needRetry()) {
                future.completeExceptionally(this.lastException);
                return;
            }
            Duration backoffDelay = this.getBackoffDelay();
            if (!backoffDelay.isZero()) {
                try {
                    TimeUnit.SECONDS.sleep(backoffDelay.getSeconds());
                }
                catch (InterruptedException e) {
                    TeaAsyncHandler.this.logger.error("Task defer failed, error message: {}", e.getMessage());
                }
            }
            this.attemptExecute(future);
        }

        private void retryThenExecute(CompletableFuture<TeaModel> future, Throwable exception, HttpResponse lastResponse) {
            this.lastException = exception;
            this.lastHttpResponse = lastResponse;
            this.retryThenExecute(future);
        }

        private boolean isFirstRequest() {
            return this.attemptNumber == 1;
        }

        private boolean needRetry() {
            if (this.isFirstRequest()) {
                return true;
            }
            if (this.retryPolicy == null) {
                return false;
            }
            return this.retryPolicy.aggregateRetryCondition().shouldRetry(this.retryContext);
        }

        private Duration getBackoffDelay() {
            Duration result = this.isFirstRequest() ? Duration.ZERO : this.retryPolicy.backoffStrategy().computeDelayBeforeNextRetry(this.retryContext);
            return result;
        }

        private void attemptExecute(CompletableFuture<TeaModel> future) {
            InterceptorChain interceptorChain = this.configuration.option(ClientOption.INTERCEPTOR_CHAIN);
            CompletableFuture<HttpResponse> responseFuture = null;
            try {
                this.interceptorContext = interceptorChain.modifyHttpRequest(this.interceptorContext, this.attributes);
                responseFuture = this.httpClient.send(TeaAsyncHandler.this.composeHttpRequest(this.interceptorContext), TeaAsyncHandler.this.composeHttpRequestContext(this.interceptorContext, this.attributes));
            }
            catch (ClientException | TeaException e) {
                this.retryThenExecute(future, e, null);
                return;
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
                return;
            }
            responseFuture.whenComplete((response, exception) -> {
                if (exception != null) {
                    this.retryThenExecute(future, (Throwable)exception, (HttpResponse)response);
                    return;
                }
                try {
                    this.interceptorContext.setHttpResponse((HttpResponse)response);
                    this.interceptorContext = interceptorChain.modifyResponse(this.interceptorContext, this.attributes);
                    if (!CommonUtil.is2xx(response.getStatusCode()) || this.interceptorContext.teaResponse().exception() != null) {
                        this.retryThenExecute(future, this.interceptorContext.teaResponse().exception(), (HttpResponse)response);
                        return;
                    }
                    this.interceptorContext = interceptorChain.modifyOutput(this.interceptorContext, this.attributes);
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    return;
                }
                future.complete((TeaModel)this.interceptorContext.output());
            });
        }
    }

    protected static abstract class BuilderImpl<ProviderT, BuilderT extends Builder>
    implements Builder<ProviderT, BuilderT> {
        private HttpClient httpClient;
        private ClientConfiguration configuration = ClientConfiguration.create();

        protected BuilderImpl() {
        }

        @Override
        public BuilderT httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return (BuilderT)this;
        }

        @Override
        public BuilderT configuration(ClientConfiguration configuration) {
            this.configuration = configuration;
            return (BuilderT)this;
        }
    }

    public static interface Builder<ProviderT, BuilderT extends Builder> {
        public BuilderT httpClient(HttpClient var1);

        public BuilderT configuration(ClientConfiguration var1);

        public ProviderT build();
    }
}

