/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.async;

import com.aliyun.core.utils.BinaryUtils;
import darabonba.core.TeaRequestBody;
import darabonba.core.internal.async.ByteArrayAsyncRequestBody;
import darabonba.core.internal.async.FileAsyncRequestBody;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public interface AsyncRequestBody
extends Publisher<ByteBuffer>,
TeaRequestBody {
    public static AsyncRequestBody fromPublisher(final Publisher<ByteBuffer> publisher) {
        return new AsyncRequestBody(){

            @Override
            public Optional<Long> contentLength() {
                return Optional.empty();
            }

            @Override
            public Optional<String> contentType() {
                return Optional.empty();
            }

            public void subscribe(Subscriber<? super ByteBuffer> s) {
                publisher.subscribe(s);
            }
        };
    }

    public static AsyncRequestBody fromFile(Path path) {
        return new FileAsyncRequestBody(path);
    }

    public static AsyncRequestBody fromFile(File file) {
        return new FileAsyncRequestBody(file.toPath());
    }

    public static AsyncRequestBody fromString(String string, Charset cs) {
        return new ByteArrayAsyncRequestBody(string.getBytes(cs));
    }

    public static AsyncRequestBody fromString(String string) {
        return AsyncRequestBody.fromString(string, StandardCharsets.UTF_8);
    }

    public static AsyncRequestBody fromBytes(byte[] bytes) {
        return new ByteArrayAsyncRequestBody(bytes);
    }

    public static AsyncRequestBody fromByteBuffer(ByteBuffer byteBuffer) {
        return new ByteArrayAsyncRequestBody(BinaryUtils.copyAllBytesFrom(byteBuffer));
    }

    public static AsyncRequestBody empty() {
        return AsyncRequestBody.fromBytes(new byte[0]);
    }
}

