/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.interceptor;

import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.SdkAutoCloseable;
import darabonba.core.TeaConfiguration;
import darabonba.core.TeaModel;
import darabonba.core.TeaRequest;
import darabonba.core.TeaResponse;
import darabonba.core.interceptor.ConfigurationInterceptor;
import darabonba.core.interceptor.HttpRequestInterceptor;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.OutputInterceptor;
import darabonba.core.interceptor.RequestInterceptor;
import darabonba.core.interceptor.ResponseInterceptor;
import java.util.ArrayList;
import java.util.List;

public class InterceptorChain
implements SdkAutoCloseable {
    private List<ConfigurationInterceptor> configurationInterceptors = new ArrayList<ConfigurationInterceptor>();
    private List<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();
    private List<HttpRequestInterceptor> httpRequestInterceptors = new ArrayList<HttpRequestInterceptor>();
    private List<ResponseInterceptor> responseInterceptors = new ArrayList<ResponseInterceptor>();
    private List<OutputInterceptor> outputInterceptors = new ArrayList<OutputInterceptor>();

    private InterceptorChain() {
    }

    public static InterceptorChain create() {
        return new InterceptorChain();
    }

    public void addConfigurationInterceptor(ConfigurationInterceptor interceptor) {
        this.configurationInterceptors.add(interceptor);
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        this.requestInterceptors.add(interceptor);
    }

    public void addHttpRequestInterceptor(HttpRequestInterceptor interceptor) {
        this.httpRequestInterceptors.add(interceptor);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        this.responseInterceptors.add(interceptor);
    }

    public void addOutputInterceptor(OutputInterceptor interceptor) {
        this.outputInterceptors.add(interceptor);
    }

    @Override
    public void close() {
        this.configurationInterceptors.clear();
        this.requestInterceptors.clear();
        this.httpRequestInterceptors.clear();
        this.responseInterceptors.clear();
        this.outputInterceptors.clear();
    }

    public InterceptorContext modifyConfiguration(InterceptorContext context, AttributeMap attributes) {
        InterceptorContext result = context;
        for (ConfigurationInterceptor interceptor : this.configurationInterceptors) {
            TeaConfiguration interceptorResult = interceptor.modifyConfiguration(result, attributes);
            result.setConfiguration(interceptorResult);
        }
        return result;
    }

    public InterceptorContext modifyRequest(InterceptorContext context, AttributeMap attributes) {
        InterceptorContext result = context;
        for (RequestInterceptor interceptor : this.requestInterceptors) {
            TeaRequest interceptorResult = interceptor.modifyRequest(result, attributes);
            result.setTeaRequest(interceptorResult);
        }
        return result;
    }

    public InterceptorContext modifyHttpRequest(InterceptorContext context, AttributeMap attributes) {
        InterceptorContext result = context;
        for (HttpRequestInterceptor interceptor : this.httpRequestInterceptors) {
            HttpRequest interceptorResult = interceptor.modifyHttpRequest(result, attributes);
            result.setHttpRequest(interceptorResult);
        }
        return result;
    }

    public InterceptorContext modifyResponse(InterceptorContext context, AttributeMap attributes) {
        InterceptorContext result = context;
        for (ResponseInterceptor interceptor : this.responseInterceptors) {
            TeaResponse interceptorResult = interceptor.modifyResponse(result, attributes);
            result.setTeaResponse(interceptorResult);
        }
        return result;
    }

    public InterceptorContext modifyOutput(InterceptorContext context, AttributeMap attributes) {
        InterceptorContext result = context;
        for (OutputInterceptor interceptor : this.outputInterceptors) {
            TeaModel interceptorResult = interceptor.modifyOutput(result, attributes);
            result.setOutput(interceptorResult);
        }
        return result;
    }
}

